/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod;

import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.chunk.ChunkGeneratorFactory;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.TerraGenSettings;
import com.terraforged.mod.chunk.test.TestChunkGenerator;
import com.terraforged.mod.gui.SettingsScreen;
import com.terraforged.mod.settings.SettingsHelper;
import com.terraforged.mod.settings.TerraSettings;
import com.terraforged.mod.util.Environment;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TerraWorld
extends WorldType {
    public static final int VERSION = 1;
    private static final Set<WorldType> types = new HashSet<WorldType>();
    private final ChunkGeneratorFactory<?> factory;

    public TerraWorld(String name, ChunkGeneratorFactory<?> factory) {
        super(name);
        this.factory = factory;
        this.func_205392_a(true);
        types.add(this);
    }

    public double getHorizon(World world) {
        return 0.0;
    }

    public float getCloudHeight() {
        return 260.0f;
    }

    public ChunkGenerator<?> createChunkGenerator(World world) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return world.func_201675_m().func_186060_c();
        }
        Log.debug("Creating {} generator", world.func_201675_m().func_186058_p());
        int version = SettingsHelper.getVersion(world.func_72912_H());
        TerraSettings settings = SettingsHelper.getSettings((IWorld)world);
        SettingsHelper.syncSettings(world.func_72912_H(), settings, version);
        Terrains terrains = Terrains.create(settings);
        TerraGenSettings genSettings = new TerraGenSettings(settings.structures);
        OverworldBiomeProviderSettings biomeSettings = new OverworldBiomeProviderSettings(world.func_72912_H());
        biomeSettings.func_205441_a((OverworldGenSettings)genSettings);
        world.func_72912_H().func_212242_b(NBTHelper.serializeCompact(settings));
        TerraContext context = new TerraContext((IWorld)world, terrains, settings);
        BiomeProvider biomeProvider = new BiomeProvider(context);
        return this.getGeneratorFactory().create(context, biomeProvider, genSettings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onCustomizeButton(Minecraft mc, CreateWorldScreen gui) {
        mc.func_147108_a((Screen)new SettingsScreen(gui));
    }

    public ChunkGeneratorFactory<?> getGeneratorFactory() {
        return this.factory;
    }

    public static void init() {
        Log.info("Registered world type", new Object[0]);
        new TerraWorld("terraforged", TerraChunkGenerator::new);
        if (Environment.isDev()) {
            Log.info("Registered developer world type", new Object[0]);
            new TerraWorld("terratest", TestChunkGenerator::new);
        }
    }

    public static boolean isTerraWorld(IWorld world) {
        if (world instanceof World) {
            return types.contains(((World)world).func_175624_G());
        }
        return false;
    }
}

