/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.rivermap.river.RiverNode;
import com.terraforged.core.world.terrain.Terrain;
import java.util.Random;
import me.dags.noise.domain.Domain;
import me.dags.noise.util.Vec2i;

public class PosGenerator {
    private final int size;
    private final int quadSize;
    private final Vec2i[] quads = new Vec2i[4];
    private final int padding;
    private final Domain domain;
    private final Cell<Terrain> lookup;
    private final Heightmap heightmap;
    private int i;
    private int dx;
    private int dz;

    public PosGenerator(Heightmap heightmap, Domain domain, Cell<Terrain> lookup, int size, int padding) {
        this.domain = domain;
        this.lookup = lookup;
        this.padding = padding;
        this.heightmap = heightmap;
        this.size = size;
        this.quadSize = (size - padding * 2) / 4;
        int x1 = 0;
        int y1 = 0;
        int x2 = 3 * this.quadSize;
        int y2 = 3 * this.quadSize;
        this.quads[PosGenerator.index((int)0, (int)0)] = new Vec2i(x1, y1);
        this.quads[PosGenerator.index((int)1, (int)0)] = new Vec2i(x2, y1);
        this.quads[PosGenerator.index((int)0, (int)1)] = new Vec2i(x1, y2);
        this.quads[PosGenerator.index((int)1, (int)1)] = new Vec2i(x2, y2);
    }

    private void nextSeed(Random random) {
        int index = random.nextInt(4);
        Vec2i vec = this.quads[index];
        this.i = index;
        this.dx = this.padding + vec.x + random.nextInt(this.quadSize);
        this.dz = this.padding + vec.y + random.nextInt(this.quadSize);
    }

    private void nextPos(Random random) {
        int steps = 1 + random.nextInt(3);
        int index = this.i + steps & 3;
        Vec2i vec = this.quads[index];
        this.i = index;
        this.dx = this.padding + vec.x + random.nextInt(this.quadSize);
        this.dz = this.padding + vec.y + random.nextInt(this.quadSize);
    }

    public RiverNode next(int x, int z, Random random, int attempts) {
        for (int i = 0; i < attempts; ++i) {
            this.nextSeed(random);
            int px = x + this.dx;
            int pz = z + this.dz;
            int wx = (int)this.domain.getX(px, pz);
            int wz = (int)this.domain.getY(px, pz);
            float value1 = this.getHeight(px, pz);
            float value2 = this.getHeight(wx, wz);
            RiverNode.Type type1 = RiverNode.getType(value1);
            RiverNode.Type type2 = RiverNode.getType(value2);
            if (type1 != type2 || type1 == RiverNode.Type.NONE) continue;
            if (type1 == RiverNode.Type.END) {
                return new RiverNode(wx, wz, type1);
            }
            return new RiverNode(px, pz, type1);
        }
        return null;
    }

    public RiverNode nextFrom(int x, int z, Random random, int attempts, RiverNode point, int mindDist2) {
        for (int i = 0; i < attempts; ++i) {
            RiverNode.Type type2;
            this.nextPos(random);
            int px = x + this.dx;
            int pz = z + this.dz;
            if (PosGenerator.dist2(px, pz, point.x, point.z) < (float)mindDist2) continue;
            int wx = (int)this.domain.getX(px, pz);
            int wz = (int)this.domain.getY(px, pz);
            float value1 = this.getHeight(px, pz);
            float value2 = this.getHeight(wx, wz);
            RiverNode.Type type1 = RiverNode.getType(value1);
            if (type1 != (type2 = RiverNode.getType(value2)) || type1 != point.type.opposite()) continue;
            if (type1 == RiverNode.Type.END) {
                return new RiverNode(wx, wz, type1);
            }
            return new RiverNode(px, pz, type1);
        }
        return null;
    }

    public RiverNode nextRelaxed(int x, int z, Random random, int attempts) {
        for (int i = 0; i < attempts; ++i) {
            RiverNode.Type type2;
            int px = x + random.nextInt(this.size);
            int pz = z + random.nextInt(this.size);
            int wx = (int)this.domain.getX(px, pz);
            int wz = (int)this.domain.getY(px, pz);
            float value1 = this.getHeight(px, pz);
            float value2 = this.getHeight(wx, wz);
            RiverNode.Type type1 = RiverNode.getType(value1);
            if (type1 != (type2 = RiverNode.getType(value2)) || type1 == RiverNode.Type.NONE) continue;
            if (type1 == RiverNode.Type.END) {
                return new RiverNode(wx, wz, type1);
            }
            return new RiverNode(px, pz, type1);
        }
        return null;
    }

    public RiverNode nextFromRelaxed(int x, int z, Random random, int attempts, RiverNode point, int mindDist2) {
        for (int i = 0; i < attempts; ++i) {
            RiverNode.Type type2;
            int pz;
            int px = x + random.nextInt(this.size);
            if (PosGenerator.dist2(px, pz = z + random.nextInt(this.size), point.x, point.z) < (float)mindDist2) continue;
            int wx = (int)this.domain.getX(px, pz);
            int wz = (int)this.domain.getY(px, pz);
            float value1 = this.getHeight(px, pz);
            float value2 = this.getHeight(wx, wz);
            RiverNode.Type type1 = RiverNode.getType(value1);
            if (type1 != (type2 = RiverNode.getType(value2)) || type1 != point.type.opposite()) continue;
            if (type1 == RiverNode.Type.END) {
                return new RiverNode(wx, wz, type1);
            }
            return new RiverNode(px, pz, type1);
        }
        return null;
    }

    public RiverNode nextType(int x, int z, Random random, int attempts, RiverNode.Type match) {
        for (int i = 0; i < attempts; ++i) {
            this.nextSeed(random);
            int px = x + this.dx;
            int pz = z + this.dz;
            int wx = (int)this.domain.getX(px, pz);
            int wz = (int)this.domain.getY(px, pz);
            float value1 = this.getHeight(px, pz);
            float value2 = this.getHeight(wx, wz);
            RiverNode.Type type1 = RiverNode.getType(value1);
            RiverNode.Type type2 = RiverNode.getType(value2);
            if (type1 != type2 || type1 != match) continue;
            return new RiverNode(px, pz, type1);
        }
        return null;
    }

    public RiverNode nextMinHeight(int x, int z, Random random, int attempts, float minHeight) {
        for (int i = 0; i < attempts; ++i) {
            this.nextPos(random);
            int px = x + this.dx;
            int pz = z + this.dz;
            int wx = (int)this.domain.getX(px, pz);
            int wz = (int)this.domain.getY(px, pz);
            float value1 = this.getHeight(px, pz);
            float value2 = this.getHeight(wx, wz);
            if (!(value1 > minHeight) || !(value2 > minHeight)) continue;
            return new RiverNode(px, pz, RiverNode.Type.START);
        }
        return null;
    }

    public float getHeight(int x, int z) {
        this.heightmap.visit(this.lookup, x, z);
        return this.lookup.value;
    }

    private static int index(int x, int z) {
        return z * 2 + x;
    }

    private static float dist2(int x1, int y1, int x2, int y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return dx * dx + dy * dy;
    }
}

