/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.material.geology;

import me.dags.noise.util.NoiseUtil;

public class StrataConfig {
    public Config soil = new Config(0, 1, 0.1f, 0.25f);
    public Config sediment = new Config(0, 2, 0.05f, 0.15f);
    public Config clay = new Config(0, 2, 0.05f, 0.1f);
    public Config rock = new Config(10, 30, 0.1f, 1.5f);

    public static class Config {
        public int minLayers;
        public int maxLayers;
        public float minDepth;
        public float maxDepth;

        public Config() {
        }

        public Config(int minLayers, int maxLayers, float minDepth, float maxDepth) {
            this.minLayers = minLayers;
            this.maxLayers = maxLayers;
            this.minDepth = minDepth;
            this.maxDepth = maxDepth;
        }

        public int getLayers(float value) {
            int range = this.maxLayers - this.minLayers;
            return this.minLayers + NoiseUtil.round(value * (float)range);
        }

        public float getDepth(float value) {
            float range = this.maxDepth - this.minDepth;
            return this.minDepth + value * range;
        }
    }
}

