/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.textures.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;

public class GuiIconButton
extends Button {
    private final IDrawable icon;

    public GuiIconButton(IDrawable icon, Button.IPressable pressable) {
        super(0, 0, 0, 0, "", pressable);
        this.icon = icon;
    }

    public void updateBounds(Rectangle2d area) {
        this.x = area.func_199318_a();
        this.y = area.func_199319_b();
        this.width = area.func_199316_c();
        this.height = area.func_199317_d();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Textures textures = Internal.getTextures();
            Minecraft minecraft = Minecraft.func_71410_x();
            DrawableNineSliceTexture texture = textures.getButtonForState(this.active, hovered);
            texture.draw(this.x, this.y, this.width, this.height);
            this.renderBg(minecraft, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            } else if (!this.active) {
                color = 0xA0A0A0;
            } else if (hovered) {
                color = 0xFFFFA0;
            }
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            RenderSystem.color4f((float)red, (float)blue, (float)green, (float)alpha);
            double xOffset = (double)this.x + (double)(this.width - this.icon.getWidth()) / 2.0;
            double yOffset = (double)this.y + (double)(this.height - this.icon.getHeight()) / 2.0;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)xOffset, (double)yOffset, (double)0.0);
            this.icon.draw();
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

