/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CanyonWorldCarver;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.NetherCaveWorldCarver;
import net.minecraft.world.gen.carver.UnderwaterCanyonWorldCarver;
import net.minecraft.world.gen.carver.UnderwaterCaveWorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class WorldCarver<C extends ICarverConfig>
extends ForgeRegistryEntry<WorldCarver<?>> {
    public static final WorldCarver<ProbabilityConfig> field_222709_a = WorldCarver.func_222699_a("cave", new CaveWorldCarver(ProbabilityConfig::func_214645_a, 256));
    public static final WorldCarver<ProbabilityConfig> field_222710_b = WorldCarver.func_222699_a("hell_cave", new NetherCaveWorldCarver(ProbabilityConfig::func_214645_a));
    public static final WorldCarver<ProbabilityConfig> field_222711_c = WorldCarver.func_222699_a("canyon", new CanyonWorldCarver(ProbabilityConfig::func_214645_a));
    public static final WorldCarver<ProbabilityConfig> field_222712_d = WorldCarver.func_222699_a("underwater_canyon", new UnderwaterCanyonWorldCarver(ProbabilityConfig::func_214645_a));
    public static final WorldCarver<ProbabilityConfig> field_222713_e = WorldCarver.func_222699_a("underwater_cave", new UnderwaterCaveWorldCarver(ProbabilityConfig::func_214645_a));
    protected static final BlockState field_222714_f = Blocks.field_150350_a.func_176223_P();
    protected static final BlockState field_222715_g = Blocks.field_201941_jj.func_176223_P();
    protected static final IFluidState field_222716_h = Fluids.field_204546_a.func_207188_f();
    protected static final IFluidState field_222717_i = Fluids.field_204547_b.func_207188_f();
    protected Set<Block> field_222718_j = ImmutableSet.of((Object)((Object)Blocks.field_150348_b), (Object)((Object)Blocks.field_196650_c), (Object)((Object)Blocks.field_196654_e), (Object)((Object)Blocks.field_196656_g), (Object)((Object)Blocks.field_150346_d), (Object)((Object)Blocks.field_196660_k), (Object[])new Block[]{Blocks.field_196661_l, Blocks.field_196658_i, Blocks.field_150405_ch, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150391_bh, Blocks.field_150433_aE, Blocks.field_150403_cj});
    protected Set<Fluid> field_222719_k = ImmutableSet.of((Object)Fluids.field_204546_a);
    private final Function<Dynamic<?>, ? extends C> field_222721_m;
    protected final int field_222720_l;

    private static <C extends ICarverConfig, F extends WorldCarver<C>> F func_222699_a(String key, F carver) {
        return (F)((Object)Registry.func_218325_a(Registry.field_218377_o, key, carver));
    }

    public WorldCarver(Function<Dynamic<?>, ? extends C> p_i49921_1_, int p_i49921_2_) {
        this.field_222721_m = p_i49921_1_;
        this.field_222720_l = p_i49921_2_;
    }

    public int func_222704_c() {
        return 4;
    }

    protected boolean func_227208_a_(IChunk p_227208_1_, Function<BlockPos, Biome> p_227208_2_, long p_227208_3_, int p_227208_5_, int p_227208_6_, int p_227208_7_, double p_227208_8_, double p_227208_10_, double p_227208_12_, double p_227208_14_, double p_227208_16_, BitSet p_227208_18_) {
        Random random = new Random(p_227208_3_ + (long)p_227208_6_ + (long)p_227208_7_);
        double d0 = p_227208_6_ * 16 + 8;
        double d1 = p_227208_7_ * 16 + 8;
        if (!(p_227208_8_ < d0 - 16.0 - p_227208_14_ * 2.0 || p_227208_12_ < d1 - 16.0 - p_227208_14_ * 2.0 || p_227208_8_ > d0 + 16.0 + p_227208_14_ * 2.0 || p_227208_12_ > d1 + 16.0 + p_227208_14_ * 2.0)) {
            int j1;
            int i1;
            int l;
            int k;
            int j;
            int i = Math.max(MathHelper.func_76128_c((double)(p_227208_8_ - p_227208_14_)) - p_227208_6_ * 16 - 1, 0);
            if (this.func_222700_a(p_227208_1_, p_227208_6_, p_227208_7_, i, j = Math.min(MathHelper.func_76128_c((double)(p_227208_8_ + p_227208_14_)) - p_227208_6_ * 16 + 1, 16), k = Math.max(MathHelper.func_76128_c((double)(p_227208_10_ - p_227208_16_)) - 1, 1), l = Math.min(MathHelper.func_76128_c((double)(p_227208_10_ + p_227208_16_)) + 1, this.field_222720_l - 8), i1 = Math.max(MathHelper.func_76128_c((double)(p_227208_12_ - p_227208_14_)) - p_227208_7_ * 16 - 1, 0), j1 = Math.min(MathHelper.func_76128_c((double)(p_227208_12_ + p_227208_14_)) - p_227208_7_ * 16 + 1, 16))) {
                return false;
            }
            boolean flag = false;
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            BlockPos.Mutable blockpos$mutable1 = new BlockPos.Mutable();
            BlockPos.Mutable blockpos$mutable2 = new BlockPos.Mutable();
            for (int k1 = i; k1 < j; ++k1) {
                int l1 = k1 + p_227208_6_ * 16;
                double d2 = ((double)l1 + 0.5 - p_227208_8_) / p_227208_14_;
                for (int i2 = i1; i2 < j1; ++i2) {
                    int j2 = i2 + p_227208_7_ * 16;
                    double d3 = ((double)j2 + 0.5 - p_227208_12_) / p_227208_14_;
                    if (d2 * d2 + d3 * d3 >= 1.0) continue;
                    AtomicBoolean atomicboolean = new AtomicBoolean(false);
                    for (int k2 = l; k2 > k; --k2) {
                        double d4 = ((double)k2 - 0.5 - p_227208_10_) / p_227208_16_;
                        if (this.func_222708_a(d2, d4, d3, k2)) continue;
                        flag |= this.func_225556_a_(p_227208_1_, p_227208_2_, p_227208_18_, random, blockpos$mutable, blockpos$mutable1, blockpos$mutable2, p_227208_5_, p_227208_6_, p_227208_7_, l1, j2, k1, k2, i2, atomicboolean);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    protected boolean func_225556_a_(IChunk p_225556_1_, Function<BlockPos, Biome> p_225556_2_, BitSet p_225556_3_, Random p_225556_4_, BlockPos.Mutable p_225556_5_, BlockPos.Mutable p_225556_6_, BlockPos.Mutable p_225556_7_, int p_225556_8_, int p_225556_9_, int p_225556_10_, int p_225556_11_, int p_225556_12_, int p_225556_13_, int p_225556_14_, int p_225556_15_, AtomicBoolean p_225556_16_) {
        int i = p_225556_13_ | p_225556_15_ << 4 | p_225556_14_ << 8;
        if (p_225556_3_.get(i)) {
            return false;
        }
        p_225556_3_.set(i);
        p_225556_5_.func_181079_c(p_225556_11_, p_225556_14_, p_225556_12_);
        BlockState blockstate = p_225556_1_.func_180495_p((BlockPos)p_225556_5_);
        BlockState blockstate1 = p_225556_1_.func_180495_p((BlockPos)p_225556_6_.func_189533_g((Vec3i)p_225556_5_).func_189536_c(Direction.UP));
        if (blockstate.func_177230_c() == Blocks.field_196658_i || blockstate.func_177230_c() == Blocks.field_150391_bh) {
            p_225556_16_.set(true);
        }
        if (!this.func_222707_a(blockstate, blockstate1)) {
            return false;
        }
        if (p_225556_14_ < 11) {
            p_225556_1_.func_177436_a((BlockPos)p_225556_5_, field_222717_i.func_206883_i(), false);
        } else {
            p_225556_1_.func_177436_a((BlockPos)p_225556_5_, field_222715_g, false);
            if (p_225556_16_.get()) {
                p_225556_7_.func_189533_g((Vec3i)p_225556_5_).func_189536_c(Direction.DOWN);
                if (p_225556_1_.func_180495_p((BlockPos)p_225556_7_).func_177230_c() == Blocks.field_150346_d) {
                    p_225556_1_.func_177436_a((BlockPos)p_225556_7_, p_225556_2_.apply((BlockPos)p_225556_5_).func_203944_q().func_204108_a(), false);
                }
            }
        }
        return true;
    }

    public abstract boolean func_225555_a_(IChunk var1, Function<BlockPos, Biome> var2, Random var3, int var4, int var5, int var6, int var7, int var8, BitSet var9, C var10);

    public abstract boolean func_212868_a_(Random var1, int var2, int var3, C var4);

    protected boolean func_222706_a(BlockState p_222706_1_) {
        return this.field_222718_j.contains((Object)p_222706_1_.func_177230_c());
    }

    protected boolean func_222707_a(BlockState state, BlockState aboveState) {
        Block block = state.func_177230_c();
        return this.func_222706_a(state) || (block == Blocks.field_150354_m || block == Blocks.field_150351_n) && !aboveState.func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    protected boolean func_222700_a(IChunk chunkIn, int chunkX, int chunkZ, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = minX; i < maxX; ++i) {
            for (int j = minZ; j < maxZ; ++j) {
                for (int k = minY - 1; k <= maxY + 1; ++k) {
                    if (this.field_222719_k.contains((Object)chunkIn.func_204610_c((BlockPos)blockpos$mutable.func_181079_c(i + chunkX * 16, k, j + chunkZ * 16)).func_206886_c())) {
                        return true;
                    }
                    if (k == maxY + 1 || this.func_222701_a(minX, maxX, minZ, maxZ, i, j)) continue;
                    k = maxY;
                }
            }
        }
        return false;
    }

    private boolean func_222701_a(int minX, int maxX, int minZ, int maxZ, int x, int z) {
        return x == minX || x == maxX - 1 || z == minZ || z == maxZ - 1;
    }

    protected boolean func_222702_a(int p_222702_1_, int p_222702_2_, double p_222702_3_, double p_222702_5_, int p_222702_7_, int p_222702_8_, float p_222702_9_) {
        double d0 = p_222702_1_ * 16 + 8;
        double d2 = p_222702_3_ - d0;
        double d1 = p_222702_2_ * 16 + 8;
        double d3 = p_222702_5_ - d1;
        double d4 = p_222702_8_ - p_222702_7_;
        double d5 = p_222702_9_ + 2.0f + 16.0f;
        return d2 * d2 + d3 * d3 - d4 * d4 <= d5 * d5;
    }

    protected abstract boolean func_222708_a(double var1, double var3, double var5, int var7);
}

