/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.merchant.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.VillagerTasks;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.LongSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VillagerEntity
extends AbstractVillagerEntity
implements IReputationTracking,
IVillagerDataHolder {
    private static final DataParameter<VillagerData> field_213775_bC = EntityDataManager.func_187226_a(VillagerEntity.class, DataSerializers.field_218813_q);
    public static final Map<Item, Integer> field_213788_bA = ImmutableMap.of((Object)((Object)Items.field_151025_P), (Object)4, (Object)((Object)Items.field_151174_bG), (Object)1, (Object)((Object)Items.field_151172_bF), (Object)1, (Object)((Object)Items.field_185164_cV), (Object)1);
    private static final Set<Item> field_213776_bD = ImmutableSet.of((Object)((Object)Items.field_151025_P), (Object)((Object)Items.field_151174_bG), (Object)((Object)Items.field_151172_bF), (Object)((Object)Items.field_151015_O), (Object)((Object)Items.field_151014_N), (Object)((Object)Items.field_185164_cV), (Object[])new Item[]{Items.field_185163_cU});
    private int field_70961_j;
    private boolean field_213777_bF;
    @Nullable
    private PlayerEntity field_213778_bG;
    private byte field_213781_bL;
    private final GossipManager field_213782_bM = new GossipManager();
    private long field_213783_bN;
    private long field_223362_bL;
    private int field_213784_bO;
    private long field_213785_bP;
    private int field_223725_bO;
    private long field_223726_bP;
    private static final ImmutableList<MemoryModuleType<?>> field_213786_bQ = ImmutableList.of(MemoryModuleType.field_220941_b, MemoryModuleType.field_220942_c, MemoryModuleType.field_220943_d, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220947_h, MemoryModuleType.field_220948_i, MemoryModuleType.field_220949_j, MemoryModuleType.field_220950_k, MemoryModuleType.field_220951_l, MemoryModuleType.field_220952_m, MemoryModuleType.field_220953_n, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220954_o, MemoryModuleType.field_220955_p, MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220944_e, MemoryModuleType.field_220961_v, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_, MemoryModuleType.field_223544_z, MemoryModuleType.field_223542_x});
    private static final ImmutableList<SensorType<? extends Sensor<? super VillagerEntity>>> field_213787_bR = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_221000_d, SensorType.field_221001_e, SensorType.field_221002_f, SensorType.field_221003_g, SensorType.field_221004_h, SensorType.field_221005_i, SensorType.field_223547_j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<VillagerEntity, PointOfInterestType>> field_213774_bB = ImmutableMap.of(MemoryModuleType.field_220941_b, (p_213769_0_, p_213769_1_) -> p_213769_1_ == PointOfInterestType.field_221069_q, MemoryModuleType.field_220942_c, (p_213771_0_, p_213771_1_) -> p_213771_0_.func_213700_eh().func_221130_b().func_221149_b() == p_213771_1_, MemoryModuleType.field_220943_d, (p_213772_0_, p_213772_1_) -> p_213772_1_ == PointOfInterestType.field_221070_r);

    public VillagerEntity(EntityType<? extends VillagerEntity> type, World worldIn) {
        this(type, worldIn, IVillagerType.field_221175_c);
    }

    public VillagerEntity(EntityType<? extends VillagerEntity> p_i50183_1_, World worldIn, IVillagerType p_i50183_3_) {
        super(p_i50183_1_, worldIn);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_98053_h(true);
        this.func_213753_a(this.func_213700_eh().func_221134_a(p_i50183_3_).func_221126_a(VillagerProfession.field_221151_a));
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
    }

    public Brain<VillagerEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = new Brain(field_213786_bQ, field_213787_bR, dynamicIn);
        this.func_213744_a((Brain<VillagerEntity>)brain);
        return brain;
    }

    public void func_213770_a(ServerWorld serverWorldIn) {
        Brain<VillagerEntity> brain = this.func_213375_cj();
        brain.func_218227_b(serverWorldIn, (LivingEntity)((Object)this));
        this.field_213378_br = brain.func_218185_f();
        this.func_213744_a(this.func_213375_cj());
    }

    private void func_213744_a(Brain<VillagerEntity> villagerBrain) {
        VillagerProfession villagerprofession = this.func_213700_eh().func_221130_b();
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        if (this.func_70631_g_()) {
            villagerBrain.func_218203_a(Schedule.field_221385_c);
            villagerBrain.func_218208_a(Activity.field_221368_d, VillagerTasks.func_220645_a((float)f));
        } else {
            villagerBrain.func_218203_a(Schedule.field_221386_d);
            villagerBrain.func_218224_a(Activity.field_221367_c, VillagerTasks.func_220639_b((VillagerProfession)villagerprofession, (float)f), (Set)ImmutableSet.of((Object)Pair.of(MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        }
        villagerBrain.func_218208_a(Activity.field_221365_a, VillagerTasks.func_220638_a((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218224_a(Activity.field_221370_f, VillagerTasks.func_220637_d((VillagerProfession)villagerprofession, (float)f), (Set)ImmutableSet.of((Object)Pair.of(MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        villagerBrain.func_218208_a(Activity.field_221369_e, VillagerTasks.func_220635_c((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218208_a(Activity.field_221366_b, VillagerTasks.func_220641_e((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218208_a(Activity.field_221371_g, VillagerTasks.func_220636_f((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218208_a(Activity.field_221373_i, VillagerTasks.func_220642_g((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218208_a(Activity.field_221372_h, VillagerTasks.func_220640_h((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218208_a(Activity.field_221374_j, VillagerTasks.func_220644_i((VillagerProfession)villagerprofession, (float)f));
        villagerBrain.func_218199_a((Set)ImmutableSet.of((Object)((Object)Activity.field_221365_a)));
        villagerBrain.func_218200_b(Activity.field_221366_b);
        villagerBrain.func_218202_a(Activity.field_221366_b);
        villagerBrain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213770_a((ServerWorld)this.field_70170_p);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    protected void func_70619_bc() {
        Raid raid;
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)((Object)this));
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.func_213716_dX() && this.field_70961_j > 0) {
            --this.field_70961_j;
            if (this.field_70961_j <= 0) {
                if (this.field_213777_bF) {
                    this.func_175554_cu();
                    this.field_213777_bF = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.field_213778_bG != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221033_e, this.field_213778_bG, this);
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)14);
            this.field_213778_bG = null;
        }
        if (!this.func_175446_cd() && this.field_70146_Z.nextInt(100) == 0 && (raid = ((ServerWorld)this.field_70170_p).func_217475_c_(new BlockPos((Entity)((Object)this)))) != null && raid.func_221333_v() && !raid.func_221319_a()) {
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)42);
        }
        if (this.func_213700_eh().func_221130_b() == VillagerProfession.field_221151_a && this.func_213716_dX()) {
            this.func_213750_eg();
        }
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        this.func_223343_eC();
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (LivingEntity)((Object)this), hand);
            return true;
        }
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70608_bn() && !player.func_226563_dT_()) {
            if (this.func_70631_g_()) {
                this.func_213756_es();
                return super.func_184645_a(player, hand);
            }
            boolean flag1 = this.func_213706_dY().isEmpty();
            if (hand == Hand.MAIN_HAND) {
                if (flag1 && !this.field_70170_p.field_72995_K) {
                    this.func_213756_es();
                }
                player.func_195066_a(Stats.field_188074_H);
            }
            if (flag1) {
                return super.func_184645_a(player, hand);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_213724_bz.isEmpty()) {
                this.func_213740_f(player);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void func_213756_es() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private void func_213740_f(PlayerEntity player) {
        this.func_213762_g(player);
        this.func_70932_a_(player);
        this.func_213707_a(player, this.func_145748_c_(), this.func_213700_eh().func_221132_c());
    }

    @Override
    public void func_70932_a_(@Nullable PlayerEntity player) {
        boolean flag = this.func_70931_l_() != null && player == null;
        super.func_70932_a_(player);
        if (flag) {
            this.func_213750_eg();
        }
    }

    @Override
    protected void func_213750_eg() {
        super.func_213750_eg();
        this.func_213748_et();
    }

    private void func_213748_et() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222220_k();
        }
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void func_213766_ei() {
        this.func_223715_ey();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        if (this.func_213700_eh().func_221130_b() == VillagerProfession.field_221156_f) {
            this.func_223359_eB();
        }
        this.field_213785_bP = this.field_70170_p.func_82737_E();
        ++this.field_223725_bO;
    }

    private boolean func_223723_ev() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_226654_r_()) continue;
            return true;
        }
        return false;
    }

    private boolean func_223720_ew() {
        return this.field_223725_bO == 0 || this.field_223725_bO < 2 && this.field_70170_p.func_82737_E() > this.field_213785_bP + 2400L;
    }

    public boolean func_223721_ek() {
        long i = this.field_213785_bP + 12000L;
        long j = this.field_70170_p.func_82737_E();
        boolean flag = j > i;
        long k = this.field_70170_p.func_72820_D();
        if (this.field_223726_bP > 0L) {
            long i1 = k / 24000L;
            long l = this.field_223726_bP / 24000L;
            flag |= i1 > l;
        }
        this.field_223726_bP = k;
        if (flag) {
            this.field_213785_bP = j;
            this.func_223718_eH();
        }
        return this.func_223720_ew() && this.func_223723_ev();
    }

    private void func_223719_ex() {
        int i = 2 - this.field_223725_bO;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222203_h();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.func_223715_ey();
        }
    }

    private void func_223715_ey() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222222_e();
        }
    }

    private void func_213762_g(PlayerEntity playerIn) {
        int i = this.func_223107_f(playerIn);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
        if (playerIn.func_70644_a(Effects.field_220310_F)) {
            EffectInstance effectinstance = playerIn.func_70660_b(Effects.field_220310_F);
            int k = effectinstance.func_76458_c();
            for (MerchantOffer merchantoffer1 : this.func_213706_dY()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.func_222218_a().func_190916_E());
                merchantoffer1.func_222207_a(-Math.max(j, 1));
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213775_bC, new VillagerData(IVillagerType.field_221175_c, VillagerProfession.field_221151_a, 1));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("VillagerData", (INBT)this.func_213700_eh().func_221131_a((DynamicOps)NBTDynamicOps.field_210820_a));
        compound.func_74774_a("FoodLevel", this.field_213781_bL);
        compound.func_218657_a("Gossips", (INBT)this.field_213782_bM.func_220914_a((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
        compound.func_74768_a("Xp", this.field_213784_bO);
        compound.func_74772_a("LastRestock", this.field_213785_bP);
        compound.func_74772_a("LastGossipDecay", this.field_223362_bL);
        compound.func_74768_a("RestocksToday", this.field_223725_bO);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("VillagerData", 10)) {
            this.func_213753_a(new VillagerData(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("VillagerData"))));
        }
        if (compound.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("FoodLevel", 1)) {
            this.field_213781_bL = compound.func_74771_c("FoodLevel");
        }
        ListNBT listnbt = compound.func_150295_c("Gossips", 10);
        this.field_213782_bM.func_220918_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)listnbt));
        if (compound.func_150297_b("Xp", 3)) {
            this.field_213784_bO = compound.func_74762_e("Xp");
        }
        this.field_213785_bP = compound.func_74763_f("LastRestock");
        this.field_223362_bL = compound.func_74763_f("LastGossipDecay");
        this.func_98053_h(true);
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213770_a((ServerWorld)this.field_70170_p);
        }
        this.field_223725_bO = compound.func_74762_e("RestocksToday");
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70608_bn()) {
            return null;
        }
        return this.func_213716_dX() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_213767_ej() {
        SoundEvent soundevent = this.func_213700_eh().func_221130_b().func_226558_e_();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213753_a(VillagerData p_213753_1_) {
        VillagerData villagerdata = this.func_213700_eh();
        if (villagerdata.func_221130_b() != p_213753_1_.func_221130_b()) {
            this.field_213724_bz = null;
        }
        this.field_70180_af.func_187227_b(field_213775_bC, p_213753_1_);
    }

    public VillagerData func_213700_eh() {
        return this.field_70180_af.func_187225_a(field_213775_bC);
    }

    @Override
    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.field_213784_bO += offer.func_222210_n();
        this.field_213778_bG = this.func_70931_l_();
        if (this.func_213741_eu()) {
            this.field_70961_j = 40;
            this.field_213777_bF = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        if (livingBase != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221031_c, livingBase, this);
            if (this.func_70089_S() && livingBase instanceof PlayerEntity) {
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)13);
            }
        }
        super.func_70604_c(livingBase);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        field_184243_a.info("Villager {} died, message: '{}'", (Object)this, (Object)cause.func_151519_b((LivingEntity)((Object)this)).getString());
        Entity entity = cause.func_76346_g();
        if (entity != null) {
            this.func_223361_a(entity);
        }
        this.func_213742_a(MemoryModuleType.field_220941_b);
        this.func_213742_a(MemoryModuleType.field_220942_c);
        this.func_213742_a(MemoryModuleType.field_220943_d);
        super.func_70645_a(cause);
    }

    private void func_223361_a(Entity p_223361_1_) {
        Optional optional;
        if (this.field_70170_p instanceof ServerWorld && (optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_220946_g)).isPresent()) {
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            ((List)optional.get()).stream().filter(p_223349_0_ -> p_223349_0_ instanceof IReputationTracking).forEach(p_223342_2_ -> serverworld.func_217489_a(IReputationType.field_221032_d, p_223361_1_, (IReputationTracking)p_223342_2_));
        }
    }

    public void func_213742_a(MemoryModuleType<GlobalPos> p_213742_1_) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer minecraftserver = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(p_213742_1_).ifPresent(p_213752_3_ -> {
                ServerWorld serverworld = minecraftserver.func_71218_a(p_213752_3_.func_218177_a());
                PointOfInterestManager pointofinterestmanager = serverworld.func_217443_B();
                Optional optional = pointofinterestmanager.func_219148_c(p_213752_3_.func_218180_b());
                BiPredicate<VillagerEntity, PointOfInterestType> bipredicate = field_213774_bB.get(p_213742_1_);
                if (optional.isPresent() && bipredicate.test(this, (PointOfInterestType)((Object)((Object)optional.get())))) {
                    pointofinterestmanager.func_219142_b(p_213752_3_.func_218180_b());
                    DebugPacketSender.func_218801_c((ServerWorld)serverworld, (BlockPos)p_213752_3_.func_218180_b());
                }
            });
        }
    }

    public boolean func_213743_em() {
        return this.field_213781_bL + this.func_213751_ew() >= 12 && this.func_70874_b() == 0;
    }

    private boolean func_223344_ex() {
        return this.field_213781_bL < 12;
    }

    private void func_213765_en() {
        if (this.func_223344_ex() && this.func_213751_ew() != 0) {
            for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
                if (itemstack.func_190926_b() || (integer = field_213788_bA.get((Object)itemstack.func_77973_b())) == null) continue;
                for (int k = j = itemstack.func_190916_E(); k > 0; --k) {
                    this.field_213781_bL = (byte)(this.field_213781_bL + integer);
                    this.func_213715_ed().func_70298_a(i, 1);
                    if (this.func_223344_ex()) continue;
                    return;
                }
            }
        }
    }

    public int func_223107_f(PlayerEntity player) {
        return this.field_213782_bM.func_220921_a(player.func_110124_au(), p_223103_0_ -> true);
    }

    private void func_213758_s(int qty) {
        this.field_213781_bL = (byte)(this.field_213781_bL - qty);
    }

    public void func_223346_ep() {
        this.func_213765_en();
        this.func_213758_s(12);
    }

    public void func_213768_b(MerchantOffers offersIn) {
        this.field_213724_bz = offersIn;
    }

    private boolean func_213741_eu() {
        int i = this.func_213700_eh().func_221132_c();
        return VillagerData.func_221128_d((int)i) && this.field_213784_bO >= VillagerData.func_221127_c((int)i);
    }

    private void func_175554_cu() {
        this.func_213753_a(this.func_213700_eh().func_221135_a(this.func_213700_eh().func_221132_c() + 1));
        this.func_213712_ef();
    }

    protected ITextComponent func_225513_by_() {
        ResourceLocation profName = this.func_213700_eh().func_221130_b().getRegistryName();
        return new TranslationTextComponent(this.func_200600_R().func_210760_d() + '.' + (!"minecraft".equals(profName.func_110624_b()) ? profName.func_110624_b() + '.' : "") + profName.func_110623_a(), new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197633_z);
        } else if (id == 13) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197609_b);
        } else if (id == 14) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197632_y);
        } else if (id == 42) {
            this.func_213718_a((IParticleData)ParticleTypes.field_218422_X);
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.BREEDING) {
            this.func_213753_a(this.func_213700_eh().func_221126_a(VillagerProfession.field_221151_a));
        }
        if (reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.SPAWNER || reason == SpawnReason.DISPENSER) {
            this.func_213753_a(this.func_213700_eh().func_221134_a(IVillagerType.func_221170_a((Biome)worldIn.func_226691_t_(new BlockPos((Entity)((Object)this))))));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public VillagerEntity func_90011_a(AgeableEntity ageable) {
        double d0 = this.field_70146_Z.nextDouble();
        IVillagerType ivillagertype = d0 < 0.5 ? IVillagerType.func_221170_a((Biome)this.field_70170_p.func_226691_t_(new BlockPos((Entity)((Object)this)))) : (d0 < 0.75 ? this.func_213700_eh().func_221129_a() : ((VillagerEntity)ageable).func_213700_eh().func_221129_a());
        VillagerEntity villagerentity = new VillagerEntity(EntityType.field_200756_av, this.field_70170_p, ivillagertype);
        villagerentity.func_213386_a(this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)villagerentity))), SpawnReason.BREEDING, null, null);
        return villagerentity;
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        WitchEntity witchentity = EntityType.field_200759_ay.func_200721_a(this.field_70170_p);
        witchentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        witchentity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)witchentity)), SpawnReason.CONVERSION, (ILivingEntityData)null, (CompoundNBT)null);
        witchentity.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            witchentity.func_200203_b(this.func_200201_e());
            witchentity.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_217376_c((Entity)witchentity);
        this.func_70106_y();
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.func_223717_b(item)) {
            Inventory inventory = this.func_213715_ed();
            boolean flag = false;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack1 = inventory.func_70301_a(i);
                if (!itemstack1.func_190926_b() && (itemstack1.func_77973_b() != item || itemstack1.func_190916_E() >= itemstack1.func_77976_d())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
            int j = inventory.func_213901_a(item);
            if (j == 256) {
                return;
            }
            if (j > 256) {
                inventory.func_223374_a(item, j - 256);
                return;
            }
            this.func_71001_a(itemEntity, itemstack.func_190916_E());
            ItemStack itemstack2 = inventory.func_174894_a(itemstack);
            if (itemstack2.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack2.func_190916_E());
            }
        }
    }

    public boolean func_223717_b(Item p_223717_1_) {
        return field_213776_bD.contains((Object)p_223717_1_) || this.func_213700_eh().func_221130_b().func_221146_c().contains((Object)p_223717_1_);
    }

    public boolean func_175555_cq() {
        return this.func_213751_ew() >= 24;
    }

    public boolean func_175557_cr() {
        return this.func_213751_ew() < 12;
    }

    private int func_213751_ew() {
        Inventory inventory = this.func_213715_ed();
        return field_213788_bA.entrySet().stream().mapToInt(p_226553_1_ -> inventory.func_213901_a((Item)((Object)((Object)p_226553_1_.getKey()))) * (Integer)p_226553_1_.getValue()).sum();
    }

    private void func_223359_eB() {
        Inventory inventory = this.func_213715_ed();
        int i = inventory.func_213901_a(Items.field_151015_O);
        int j = i / 3;
        if (j != 0) {
            int k = j * 3;
            inventory.func_223374_a(Items.field_151015_O, k);
            ItemStack itemstack = inventory.func_174894_a(new ItemStack(Items.field_151025_P, j));
            if (!itemstack.func_190926_b()) {
                this.func_70099_a(itemstack, 0.5f);
            }
        }
    }

    public boolean func_175556_cs() {
        Inventory inventory = this.func_213715_ed();
        return inventory.func_213902_a((Set)ImmutableSet.of((Object)((Object)Items.field_151014_N), (Object)((Object)Items.field_151174_bG), (Object)((Object)Items.field_151172_bF), (Object)((Object)Items.field_185163_cU)));
    }

    @Override
    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade;
        VillagerData villagerdata = this.func_213700_eh();
        Int2ObjectMap int2objectmap = (Int2ObjectMap)VillagerTrades.field_221239_a.get((Object)villagerdata.func_221130_b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ITrade[])int2objectmap.get(villagerdata.func_221132_c())) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    public void func_213746_a(VillagerEntity p_213746_1_, long gameTime) {
        if (!(gameTime >= this.field_213783_bN && gameTime < this.field_213783_bN + 1200L || gameTime >= p_213746_1_.field_213783_bN && gameTime < p_213746_1_.field_213783_bN + 1200L)) {
            this.field_213782_bM.func_220912_a(p_213746_1_.field_213782_bM, this.field_70146_Z, 10);
            this.field_213783_bN = gameTime;
            p_213746_1_.field_213783_bN = gameTime;
            this.func_223358_a(gameTime, 5);
        }
    }

    private void func_223343_eC() {
        long i = this.field_70170_p.func_82737_E();
        if (this.field_223362_bL == 0L) {
            this.field_223362_bL = i;
        } else if (i >= this.field_223362_bL + 24000L) {
            this.field_213782_bM.func_223538_b();
            this.field_223362_bL = i;
        }
    }

    public void func_223358_a(long gameTime, int requiredPeers) {
        IronGolemEntity irongolementity;
        AxisAlignedBB axisalignedbb;
        List list;
        List list1;
        if (this.func_223350_a(gameTime) && (list1 = (list = this.field_70170_p.func_217357_a(VillagerEntity.class, axisalignedbb = this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0))).stream().filter(p_226554_2_ -> p_226554_2_.func_223350_a(gameTime)).limit(5L).collect(Collectors.toList())).size() >= requiredPeers && (irongolementity = this.func_213759_ey()) != null) {
            list.forEach(p_226552_2_ -> p_226552_2_.func_223347_b(gameTime));
        }
    }

    private void func_223347_b(long p_223347_1_) {
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223542_x, (Object)p_223347_1_);
    }

    private boolean func_223354_c(long gameTime) {
        Optional optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_223542_x);
        if (!optional.isPresent()) {
            return false;
        }
        Long olong = (Long)optional.get();
        return gameTime - olong <= 600L;
    }

    public boolean func_223350_a(long gameTime) {
        VillagerData villagerdata = this.func_213700_eh();
        if (villagerdata.func_221130_b() != VillagerProfession.field_221151_a && villagerdata.func_221130_b() != VillagerProfession.field_221162_l) {
            if (!this.func_223352_d(this.field_70170_p.func_82737_E())) {
                return false;
            }
            return !this.func_223354_c(gameTime);
        }
        return false;
    }

    @Nullable
    private IronGolemEntity func_213759_ey() {
        BlockPos blockpos = new BlockPos((Entity)((Object)this));
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos2;
            IronGolemEntity irongolementity;
            double d0 = this.field_70170_p.field_73012_v.nextInt(16) - 8;
            double d1 = this.field_70170_p.field_73012_v.nextInt(16) - 8;
            double d2 = 6.0;
            for (int j = 0; j >= -12; --j) {
                BlockPos blockpos1 = blockpos.func_177963_a(d0, d2 + (double)j, d1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() && !this.field_70170_p.func_180495_p(blockpos1).func_185904_a().func_76224_d() || !this.field_70170_p.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76218_k()) continue;
                d2 += (double)j;
                break;
            }
            if ((irongolementity = EntityType.field_200757_aw.func_220349_b(this.field_70170_p, null, null, null, blockpos2 = blockpos.func_177963_a(d0, d2, d1), SpawnReason.MOB_SUMMONED, false, false)) == null) continue;
            if (irongolementity.func_213380_a(this.field_70170_p, SpawnReason.MOB_SUMMONED) && irongolementity.func_205019_a(this.field_70170_p)) {
                this.field_70170_p.func_217376_c((Entity)((Object)irongolementity));
                return irongolementity;
            }
            irongolementity.func_70106_y();
        }
        return null;
    }

    public void func_213739_a(IReputationType type, Entity target) {
        if (type == IReputationType.field_221029_a) {
            this.field_213782_bM.func_220916_a(target.func_110124_au(), GossipType.MAJOR_POSITIVE, 20);
            this.field_213782_bM.func_220916_a(target.func_110124_au(), GossipType.MINOR_POSITIVE, 25);
        } else if (type == IReputationType.field_221033_e) {
            this.field_213782_bM.func_220916_a(target.func_110124_au(), GossipType.TRADING, 2);
        } else if (type == IReputationType.field_221031_c) {
            this.field_213782_bM.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, 25);
        } else if (type == IReputationType.field_221032_d) {
            this.field_213782_bM.func_220916_a(target.func_110124_au(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    @Override
    public int func_213708_dV() {
        return this.field_213784_bO;
    }

    public void func_213761_t(int p_213761_1_) {
        this.field_213784_bO = p_213761_1_;
    }

    private void func_223718_eH() {
        this.func_223719_ex();
        this.field_223725_bO = 0;
    }

    public GossipManager func_223722_es() {
        return this.field_213782_bM;
    }

    public void func_223716_a(INBT p_223716_1_) {
        this.field_213782_bM.func_220918_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)p_223716_1_));
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)((Object)this));
    }

    public void func_213342_e(BlockPos p_213342_1_) {
        super.func_213342_e(p_213342_1_);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)LongSerializable.func_223463_a((long)this.field_70170_p.func_82737_E()));
    }

    public void func_213366_dy() {
        super.func_213366_dy();
        this.field_213378_br.func_218205_a(MemoryModuleType.field_226332_A_, (Object)LongSerializable.func_223463_a((long)this.field_70170_p.func_82737_E()));
    }

    private boolean func_223352_d(long gameTime) {
        Optional optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_223543_y);
        Optional optional1 = this.field_213378_br.func_218207_c(MemoryModuleType.field_223544_z);
        if (optional.isPresent() && optional1.isPresent()) {
            return gameTime - ((LongSerializable)optional.get()).func_223461_a() < 24000L && gameTime - ((LongSerializable)optional1.get()).func_223461_a() < 36000L;
        }
        return false;
    }
}

