/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class FrostWalkerEnchantment
extends Enchantment {
    public FrostWalkerEnchantment(Enchantment.Rarity rarityIn, EquipmentSlotType ... slots) {
        super(rarityIn, EnchantmentType.ARMOR_FEET, slots);
    }

    @Override
    public int func_77321_a(int enchantmentLevel) {
        return enchantmentLevel * 10;
    }

    @Override
    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 15;
    }

    @Override
    public boolean func_185261_e() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return 2;
    }

    public static void func_185266_a(LivingEntity living, World worldIn, BlockPos pos, int level) {
        if (living.field_70122_E) {
            BlockState blockstate = Blocks.field_185778_de.func_176223_P();
            float f = Math.min(16, 2 + level);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.func_177963_a((double)f, -1.0, (double)f))) {
                boolean isFull;
                if (!blockpos.func_218137_a((IPosition)living.func_213303_ch(), (double)f)) continue;
                blockpos$mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)blockpos$mutable);
                if (!blockstate1.isAir((IBlockReader)((Object)worldIn), (BlockPos)blockpos$mutable)) continue;
                BlockState blockstate2 = worldIn.func_180495_p(blockpos);
                boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150355_j && (Integer)blockstate2.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0;
                if (blockstate2.func_185904_a() != Material.field_151586_h || !isFull || !blockstate.func_196955_c(worldIn, blockpos) || !worldIn.func_226663_a_(blockstate, blockpos, ISelectionContext.func_216377_a()) || ForgeEventFactory.onBlockPlace((Entity)living, (BlockSnapshot)new BlockSnapshot((IWorld)worldIn, blockpos, blockstate2), (Direction)Direction.UP)) continue;
                worldIn.func_175656_a(blockpos, blockstate);
                worldIn.func_205220_G_().func_205360_a(blockpos, (Object)Blocks.field_185778_de, MathHelper.func_76136_a((Random)living.func_70681_au(), (int)60, (int)120));
            }
        }
    }

    @Override
    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_185300_i;
    }
}

