/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.selection;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.selection.SelectionPanel;
import vswe.stevesfactory.utils.NetworkHelper;

public interface IComponentChoice
extends IWidget {
    default public void renderBackground(double mouseX, double mouseY) {
        int x1 = this.getAbsoluteX();
        int y1 = this.getAbsoluteY();
        int x2 = this.getAbsoluteX() + this.getWidth();
        int y2 = this.getAbsoluteY() + this.getHeight();
        if (this.isInside(mouseX, mouseY)) {
            RenderingHelper.drawCompleteTexture(x1, y1, x2, y2, SelectionPanel.BACKGROUND_HOVERED);
        } else {
            RenderingHelper.drawCompleteTexture(x1, y1, x2, y2, SelectionPanel.BACKGROUND_NORMAL);
        }
    }

    default public void createFlowComponent(IProcedureType<?> type) {
        BlockPos controllerPos = ((FactoryManagerGUI)WidgetScreen.getCurrent()).getController().getPosition();
        INetworkController controller = (INetworkController)Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e.func_175625_s(controllerPos));
        FlowComponent<?> flowComponent = NetworkHelper.fabricateInstance(controller, type).createFlowComponent();
        flowComponent.setLocation(10, 20);
        this.getEditorPanel().addChildren(flowComponent);
    }

    public EditorPanel getEditorPanel();
}

