/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.util;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Utils {
    public static Random rand = new Random();

    public static String format(Object obj) {
        return NumberFormat.getInstance().format(obj);
    }

    public static List<String> asList(String string) {
        return Collections.singletonList(string);
    }

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static int[] hexToRGB(int hex) {
        int[] colors = new int[]{hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF};
        return colors;
    }

    private static float interpolate(float a, float b, float proportion) {
        return a + (b - a) * proportion;
    }

    public static int interpolateColor(int a, int b, float proportion) {
        float[] hsva = new float[3];
        float[] hsvb = new float[3];
        Utils.RGBtoHSB(a >> 16 & 0xFF, a >> 8 & 0xFF, a & 0xFF, hsva);
        Utils.RGBtoHSB(b >> 16 & 0xFF, b >> 8 & 0xFF, b & 0xFF, hsvb);
        for (int i = 0; i < 3; ++i) {
            hsvb[i] = Utils.interpolate(hsva[i], hsvb[i], proportion);
        }
        float alpha = Utils.interpolate(a >> 24 & 0xFF, b >> 24 & 0xFF, proportion);
        return Utils.HSBtoRGB(hsvb[0], hsvb[1], hsvb[2]) | (int)(alpha * 255.0f) & 0xFF;
    }

    public static int saturate(int color, float saturation) {
        float[] hsv = new float[3];
        Utils.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsv);
        hsv[1] = hsv[1] * saturation;
        return Utils.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
    }

    public static int hexToIntWithAlpha(int hex, int alpha) {
        return alpha << 24 | hex & 0xFFFFFF;
    }

    public static int calcAlpha(double current, double max) {
        return (int)((max - current) / max) * 255;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }
}

