/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityHeatGenerator
extends TileEntityGenerator {
    private static final int MAX_FLUID = 24000;
    private static final int FLUID_RATE = 10;
    private static final FloatingLong MAX_PRODUCTION = FloatingLong.createConst((long)500L);
    public BasicFluidTank lavaTank;
    private double thermalEfficiency = 0.5;
    private FloatingLong producingEnergy = FloatingLong.ZERO;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;
    private BasicHeatCapacitor heatCapacitor;
    private FluidFuelInventorySlot fuelSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityHeatGenerator() {
        super((IBlockProvider)GeneratorsBlocks.HEAT_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get()).multiply(2L));
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.lavaTank = BasicFluidTank.create((int)24000, fluidStack -> fluidStack.getFluid().func_207185_a(FluidTags.field_206960_b), (IMekanismFluidHandler)this);
        builder.addTank((IExtendedFluidTank)this.lavaTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.lavaTank, stack -> ForgeHooks.getBurnTime((ItemStack)stack) / 20, (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)size -> new FluidStack((Fluid)Fluids.field_204547_b, size)), (IMekanismInventory)this, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IMekanismInventory)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.heatCapacitor = BasicHeatCapacitor.create((double)10.0, (double)5.0, (double)100.0, (IMekanismHeatHandler)this);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        FloatingLong prev = this.getEnergyContainer().getEnergy().copy();
        this.heatCapacitor.handleHeat(this.getBoost().doubleValue());
        if (MekanismUtils.canFunction((TileEntity)this) && !this.getEnergyContainer().getNeeded().isZero() && this.lavaTank.extract(10, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == 10) {
            this.setActive(true);
            this.lavaTank.extract(10, Action.EXECUTE, AutomationType.INTERNAL);
            this.heatCapacitor.handleHeat(((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get()).doubleValue());
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.getAdjacentTransfer();
        this.lastEnvironmentLoss = loss.getEnvironmentTransfer();
        this.producingEnergy = this.getEnergyContainer().getEnergy().subtract(prev);
    }

    private FloatingLong getBoost() {
        if (this.field_145850_b == null) {
            return FloatingLong.ZERO;
        }
        FloatingLong boost = ((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationLava.get()).multiply(Arrays.stream(EnumUtils.DIRECTIONS).filter(side -> this.field_145850_b.func_204610_c(this.field_174879_c.func_177972_a(side)).func_206884_a(FluidTags.field_206960_b)).count());
        if (this.field_145850_b.func_201675_m().func_177495_o()) {
            boost = boost.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationNether.get());
        }
        return boost;
    }

    @Nonnull
    public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getInverseInsulation(capacitor, side);
    }

    @Nonnull
    public HeatAPI.HeatTransfer simulate() {
        double temp = this.getTotalTemperature();
        double carnotEfficiency = 1.0 - Math.min(300.0, temp) / Math.max(300.0, temp);
        double heatLost = this.thermalEfficiency * (temp - 300.0);
        this.heatCapacitor.handleHeat(-heatLost);
        this.getEnergyContainer().insert(MAX_PRODUCTION.min(FloatingLong.create((double)(Math.abs(heatLost) * carnotEfficiency))), Action.EXECUTE, AutomationType.INTERNAL);
        return super.simulate();
    }

    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        if (side == Direction.DOWN) {
            TileEntity adj = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177977_b());
            return MekanismUtils.toOptional((LazyOptional)CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER_CAPABILITY, (Direction)side.func_176734_d())).orElse(null);
        }
        return null;
    }

    public FloatingLong getProducingEnergy() {
        return this.producingEnergy;
    }

    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((double)this.lavaTank.getFluidAmount(), (double)this.lavaTank.getCapacity());
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getProducingEnergy, value -> {
            this.producingEnergy = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

