/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.GasRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@ParametersAreNonnullByDefault
public class RenderIndustrialTurbine
extends MekanismTileEntityRenderer<TileEntityTurbineCasing> {
    public RenderIndustrialTurbine(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityTurbineCasing tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.clientHasStructure && tile.isRendering && tile.structure != null && ((SynchronizedTurbineData)tile.structure).complex != null && ((SynchronizedTurbineData)tile.structure).renderLocation != null) {
            BlockPos pos = tile.func_174877_v();
            BlockPos complexPos = ((SynchronizedTurbineData)tile.structure).complex.getPos();
            IVertexBuilder buffer = RenderTurbineRotor.INSTANCE.model.getBuffer(renderer);
            profiler.func_76320_a("turbineRotor");
            while (true) {
                complexPos = complexPos.func_177977_b();
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)MekanismUtils.getTileEntity(TileEntityTurbineRotor.class, (IBlockReader)tile.func_145831_w(), (BlockPos)complexPos);
                if (rotor == null) break;
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(complexPos.func_177958_n() - pos.func_177958_n()), (double)(complexPos.func_177956_o() - pos.func_177956_o()), (double)(complexPos.func_177952_p() - pos.func_177952_p()));
                RenderTurbineRotor.INSTANCE.render(rotor, matrix, buffer, 0xF000F0, overlayLight);
                matrix.func_227865_b_();
            }
            profiler.func_76319_b();
            if (!((SynchronizedTurbineData)tile.structure).gasTank.isEmpty() && ((SynchronizedTurbineData)tile.structure).volLength > 0) {
                GasRenderData data = new GasRenderData();
                data.height = ((SynchronizedTurbineData)tile.structure).lowerVolume / (((SynchronizedTurbineData)tile.structure).volLength * ((SynchronizedTurbineData)tile.structure).volWidth);
                if (data.height >= 1) {
                    data.location = ((SynchronizedTurbineData)tile.structure).renderLocation;
                    data.length = ((SynchronizedTurbineData)tile.structure).volLength;
                    data.width = ((SynchronizedTurbineData)tile.structure).volWidth;
                    data.gasType = (GasStack)((SynchronizedTurbineData)tile.structure).gasTank.getStack();
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)(data.location.x - pos.func_177958_n()), (double)(data.location.y - pos.func_177956_o()), (double)(data.location.z - pos.func_177952_p()));
                    MekanismRenderer.Model3D gasModel = ModelRenderer.getModel((RenderData)data, (double)1.0);
                    MekanismRenderer.renderObject((MekanismRenderer.Model3D)gasModel, (MatrixStack)matrix, (IVertexBuilder)renderer.getBuffer(MekanismRenderType.resizableCuboid()), (int)data.getColorARGB(tile.prevSteamScale), (int)data.calculateGlowLight(light));
                    matrix.func_227865_b_();
                }
            }
        }
    }

    protected String getProfilerSection() {
        return "industrialTurbine";
    }

    public boolean isGlobalRenderer(TileEntityTurbineCasing tile) {
        return tile.clientHasStructure && tile.isRendering && tile.structure != null && ((SynchronizedTurbineData)tile.structure).complex != null && ((SynchronizedTurbineData)tile.structure).renderLocation != null;
    }
}

