/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import technicianlp.reauth.ReAuth;

final class Crypto {
    private static final int iterations = 100000;
    private final Cipher aes = Cipher.getInstance("AES/CBC/PKCS5Padding");
    private final SecretKeyFactory pbkdf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
    private String key;
    private byte[] salt;
    private byte[] hash;

    private byte[] crypt(int mode, byte[] secret) throws GeneralSecurityException {
        SecretKeySpec secretKey = new SecretKeySpec(this.getHash(), 0, 32, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.getHash(), 32, 16);
        this.aes.init(mode, (Key)secretKey, ivParameterSpec);
        return this.aes.doFinal(secret);
    }

    public String encryptString(String string) {
        try {
            byte[] raw = string.getBytes(StandardCharsets.UTF_8);
            byte[] enc = this.crypt(1, raw);
            return Base64.getEncoder().encodeToString(enc);
        }
        catch (GeneralSecurityException e) {
            ReAuth.log.error("Unexpected Crypto Exception", (Throwable)e);
            return "";
        }
    }

    public String decryptString(String string) {
        try {
            byte[] raw = Base64.getDecoder().decode(string);
            byte[] dec = this.crypt(2, raw);
            return new String(dec, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException e) {
            ReAuth.log.error("Unexpected Crypto Exception", (Throwable)e);
            return "";
        }
    }

    public void setup(String key, byte[] salt) {
        if (key.equals(this.key) && Arrays.equals(salt, this.salt)) {
            return;
        }
        this.key = key;
        this.salt = salt;
        this.hash = null;
    }

    private byte[] getHash() throws InvalidKeySpecException {
        if (this.hash == null) {
            this.hash = this.pbkdf.generateSecret(new PBEKeySpec(this.key.toCharArray(), this.salt, 100000, 512)).getEncoded();
        }
        return this.hash;
    }
}

