/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.message;

import com.raoulvdberge.refinedpipes.network.pipe.transport.ItemTransportProps;
import com.raoulvdberge.refinedpipes.tile.ItemPipeTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemTransportMessage {
    private final BlockPos pos;
    private final List<ItemTransportProps> props;

    public ItemTransportMessage(BlockPos pos, List<ItemTransportProps> props) {
        this.pos = pos;
        this.props = props;
    }

    public static void encode(ItemTransportMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeInt(message.props.size());
        message.props.forEach(p -> p.writeToBuffer(buf));
    }

    public static ItemTransportMessage decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        int count = buf.readInt();
        ArrayList<ItemTransportProps> props = new ArrayList<ItemTransportProps>();
        for (int i = 0; i < count; ++i) {
            props.add(ItemTransportProps.create(buf));
        }
        return new ItemTransportMessage(pos, props);
    }

    public static void handle(ItemTransportMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (tile instanceof ItemPipeTileEntity) {
                ((ItemPipeTileEntity)tile).setProps(message.props);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

