/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.blay09.mods.farmingforblockheads.FarmlandHandler;
import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class RichFarmlandLootModifier
extends LootModifier {
    public RichFarmlandLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ServerWorld world = context.func_202879_g();
        BlockPos pos = (BlockPos)context.func_216031_c(LootParameters.field_216286_f);
        BlockState plant = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (pos == null || plant == null) {
            return generatedLoot;
        }
        BlockState farmland = world.func_180495_p(pos.func_177977_b());
        if (farmland.func_177230_c() instanceof FertilizedFarmlandBlock && plant.func_177230_c() instanceof IGrowable && Math.random() <= (double)((FertilizedFarmlandBlock)farmland.func_177230_c()).getBonusCropChance()) {
            generatedLoot.stream().filter(p -> !RichFarmlandLootModifier.isProbablySeed(p)).findAny().ifPresent(arg_0 -> RichFarmlandLootModifier.lambda$doApply$1(generatedLoot, (World)world, pos, farmland, arg_0));
        }
        return generatedLoot;
    }

    private static boolean isProbablySeed(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("seed");
    }

    private static /* synthetic */ void lambda$doApply$1(List generatedLoot, World world, BlockPos pos, BlockState farmland, ItemStack c) {
        generatedLoot.add(c.func_77946_l());
        world.func_217379_c(2005, pos, 0);
        FarmlandHandler.rollRegression(world, pos, farmland);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RichFarmlandLootModifier> {
        public RichFarmlandLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            return new RichFarmlandLootModifier(conditionsIn);
        }
    }
}

