/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.RelatedUnit;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.BlockState;

public class ForgeEmitter
extends RelatedUnit
implements IEmitter {
    protected final Set<BlockState> relatedBlocks = new BlockStatesSet();
    private final String activeTag;
    private final KeyValuePair identityTag;
    private final boolean isEntity;
    private final String[] relatedBlocksArray;

    public ForgeEmitter(UnitConfig config, Properties<?> props) {
        super(config, props.id);
        this.activeTag = UnitConfig.getStr(config, this.getClassCategory(), "activeTag", props.activeTag, "Defines the name of the NBT tag that stores info about tile entity active state.\nEmitter is considered active if the return value is greater than 0 or true.\nSet to an empty string if you don't need this function.");
        this.identityTag = UnitConfig.getKeyValuePair(config, this.getClassCategory(), "identityTag", props.identityTag, "This parameter is required only for those blocks that use NBT tags to fully identify themselves.\nThe format is <tagKey>=<value>\nIf the value is a string, it must be enclosed in double quotes. Example: id=\"ic2:generator\"\nLeave this blank if you don't need it.");
        this.isEntity = UnitConfig.getBool(config, this.getClassCategory(), "isEntity", props.isEntity, "Set this to True only if this emitter is not a block or a tile but an entity.");
        this.relatedBlocksArray = UnitConfig.getStrArray(this.getConfig(), this.getClassCategory(), "relatedBlocks", props.relatedBlocks, "Defines a list of blocks which should be considered as part of this multiblock.");
        this.saveConfig();
    }

    @Override
    public String getActiveTag() {
        return this.activeTag;
    }

    @Override
    public KeyValuePair getIdentityTag() {
        return this.identityTag;
    }

    @Override
    public boolean isEntity() {
        return this.isEntity;
    }

    @Override
    public Set<BlockState> getRelatedBlocks() {
        return Collections.unmodifiableSet(this.relatedBlocks);
    }

    @Override
    public void onPostInit() {
        this.relatedBlocks.addAll(BlockStatesSet.parseFrom(this.relatedBlocksArray));
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public boolean isEntity = false;
        public String activeTag = "";
        public String fuelTag = "";
        public KeyValuePair identityTag = KeyValuePair.EMPTY;
        public String[] relatedBlocks = new String[0];

        protected Properties(Class<T> selfClazz) {
            super(selfClazz);
        }

        public T isEntity() {
            this.isEntity = true;
            return (T)((Properties)this.self);
        }

        public T activeTag(String activeTag) {
            this.activeTag = activeTag;
            return (T)((Properties)this.self);
        }

        public T identityTag(KeyValuePair identityTag) {
            this.identityTag = identityTag;
            return (T)((Properties)this.self);
        }

        public T fuelTag(String fuelTag) {
            this.fuelTag = fuelTag;
            return (T)((Properties)this.self);
        }

        public T relatedBlocks(String ... relatedBlocks) {
            this.relatedBlocks = relatedBlocks;
            return (T)((Properties)this.self);
        }
    }
}

