/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantExcavation
extends EnchantBase {
    private static final int POWER_PER_LEVEL = 7;
    private static final Direction[] VALUES = Direction.values();

    public EnchantExcavation(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_77325_b() {
        return 5;
    }

    private int getHarvestMax(int level) {
        if (level <= 5) {
            return level * 7;
        }
        return 35 + level * 2;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        int harvested;
        IWorld world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (player.field_184622_au == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        ItemStack stackHarvestingWith = player.func_184586_b(player.field_184622_au);
        int level = this.getCurrentLevelTool(stackHarvestingWith);
        if (level <= 0) {
            return;
        }
        boolean isAnySingleOk = false;
        for (ToolType type : stackHarvestingWith.func_77973_b().getToolTypes(stackHarvestingWith)) {
            if (!block.isToolEffective(world.func_180495_p(pos), type)) continue;
            isAnySingleOk = true;
        }
        if (isAnySingleOk && (harvested = this.harvestSurrounding((World)world, player, pos, block, 1, level, player.field_184622_au)) > 0) {
            player.func_184586_b(player.field_184622_au).func_96631_a(1, world.func_201674_k(), null);
        }
    }

    private int harvestSurrounding(World world, PlayerEntity player, BlockPos posIn, Block block, int totalBroken, int level, Hand swingingHand) {
        if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) {
            return totalBroken;
        }
        Set<BlockPos> theFuture = this.getMatchingSurrounding(world, posIn, block);
        HashSet<BlockPos> wasHarvested = new HashSet<BlockPos>();
        for (BlockPos targetPos : theFuture) {
            int silklevel;
            int bonusLevel;
            int exp;
            BlockState targetState = world.func_180495_p(targetPos);
            if (world.func_175623_d(targetPos) || !player.func_175142_cm() || !player.func_184823_b(targetState) || totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b() || !ForgeHooks.canHarvestBlock((BlockState)targetState, (PlayerEntity)player, (IBlockReader)world, (BlockPos)targetPos)) continue;
            if (world instanceof ServerWorld) {
                Block.func_220059_a((BlockState)targetState, (World)world, (BlockPos)targetPos, (TileEntity)world.func_175625_s(targetPos));
            }
            if ((exp = targetState.getExpDrop((IWorldReader)world, targetPos, bonusLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()), silklevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()))) > 0) {
                block.func_180637_b(world, targetPos, exp);
            }
            world.func_175655_b(targetPos, false);
            wasHarvested.add(targetPos);
            ++totalBroken;
        }
        for (BlockPos targetPos : theFuture) {
            if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) break;
            totalBroken += this.harvestSurrounding(world, player, targetPos, block, totalBroken, level, swingingHand);
        }
        return totalBroken;
    }

    private Set<BlockPos> getMatchingSurrounding(World world, BlockPos start, Block blockIn) {
        HashSet<BlockPos> list = new HashSet<BlockPos>();
        List<Direction> targetFaces = Arrays.asList(VALUES);
        Collections.shuffle(targetFaces);
        for (Direction fac : targetFaces) {
            if (world.func_180495_p(start.func_177972_a(fac)).func_177230_c() != blockIn) continue;
            list.add(start.func_177972_a(fac));
        }
        return list;
    }
}

