/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.member;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.CompareType;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.ConstExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.GetFieldExpression;
import org.openzen.zenscript.codemodel.expression.GetStaticFieldExpression;
import org.openzen.zenscript.codemodel.expression.InvalidExpression;
import org.openzen.zenscript.codemodel.expression.PostCallExpression;
import org.openzen.zenscript.codemodel.expression.SetFieldExpression;
import org.openzen.zenscript.codemodel.expression.SetStaticFieldExpression;
import org.openzen.zenscript.codemodel.expression.SetterExpression;
import org.openzen.zenscript.codemodel.expression.StaticSetterExpression;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.FunctionalMember;
import org.openzen.zenscript.codemodel.member.ref.ConstMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FieldMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.member.ref.GetterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.SetterMemberRef;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.TypeMember;
import org.openzen.zenscript.codemodel.type.member.TypeMemberPriority;

public class TypeMemberGroup {
    public static final TypeMemberGroup EMPTY = new TypeMemberGroup(false, "");
    private TypeMember<ConstMemberRef> constant;
    private TypeMember<FieldMemberRef> field;
    private TypeMember<GetterMemberRef> getter;
    private TypeMember<SetterMemberRef> setter;
    private final List<TypeMember<FunctionalMemberRef>> methods = new ArrayList<TypeMember<FunctionalMemberRef>>();
    public final boolean isStatic;
    public final String name;

    public static TypeMemberGroup forMethod(String name, FunctionalMemberRef member) {
        TypeMemberGroup instance = new TypeMemberGroup(member.isStatic(), name);
        instance.addMethod(member, TypeMemberPriority.SPECIFIED);
        return instance;
    }

    public TypeMemberGroup(boolean isStatic, String name) {
        this.isStatic = isStatic;
        this.name = name;
    }

    public void merge(TypeMemberGroup other, TypeMemberPriority priority) {
        if (other.constant != null) {
            this.setConst((ConstMemberRef)other.constant.member, priority);
        }
        if (other.field != null) {
            this.setField((FieldMemberRef)other.field.member, priority);
        }
        if (other.getter != null) {
            this.setGetter((GetterMemberRef)other.getter.member, priority);
        }
        if (other.setter != null) {
            this.setSetter((SetterMemberRef)other.setter.member, priority);
        }
        for (TypeMember<FunctionalMemberRef> method : other.methods) {
            this.addMethod((FunctionalMemberRef)method.member, priority);
        }
    }

    public FieldMemberRef getField() {
        return this.field == null ? null : (FieldMemberRef)this.field.member;
    }

    public GetterMemberRef getGetter() {
        return this.getter == null ? null : (GetterMemberRef)this.getter.member;
    }

    public SetterMemberRef getSetter() {
        return this.setter == null ? null : (SetterMemberRef)this.setter.member;
    }

    public FunctionalMemberRef getMethod(FunctionHeader header) {
        for (TypeMember<FunctionalMemberRef> method : this.methods) {
            if (!((FunctionalMemberRef)method.member).getHeader().isEquivalentTo(header)) continue;
            return (FunctionalMemberRef)method.member;
        }
        return null;
    }

    public FunctionalMemberRef getUnaryMethod() {
        for (TypeMember<FunctionalMemberRef> method : this.methods) {
            if (((FunctionalMemberRef)method.member).getHeader().parameters.length != 0) continue;
            return (FunctionalMemberRef)method.member;
        }
        return null;
    }

    public boolean hasMethods() {
        return !this.methods.isEmpty();
    }

    public boolean hasMethod(FunctionHeader header) {
        for (TypeMember<FunctionalMemberRef> method : this.methods) {
            if (!((FunctionalMemberRef)method.member).getHeader().isEquivalentTo(header)) continue;
            return true;
        }
        return false;
    }

    public FunctionalMemberRef getStaticMethod(int arguments, StoredType returnType) {
        for (TypeMember<FunctionalMemberRef> method : this.methods) {
            if (!((FunctionalMemberRef)method.member).isStatic() || !((FunctionalMemberRef)method.member).getHeader().accepts(arguments) || !((FunctionalMemberRef)method.member).getHeader().getReturnType().equals(returnType)) continue;
            return (FunctionalMemberRef)method.member;
        }
        return null;
    }

    public List<TypeMember<FunctionalMemberRef>> getMethodMembers() {
        return this.methods;
    }

    public ConstMemberRef getConstant() {
        return (ConstMemberRef)this.constant.member;
    }

    public void setConst(ConstMemberRef constant, TypeMemberPriority priority) {
        this.constant = this.constant != null ? this.constant.resolve(new TypeMember<ConstMemberRef>(priority, constant)) : new TypeMember<ConstMemberRef>(priority, constant);
    }

    public void setField(FieldMemberRef field, TypeMemberPriority priority) {
        this.field = this.field != null ? this.field.resolve(new TypeMember<FieldMemberRef>(priority, field)) : new TypeMember<FieldMemberRef>(priority, field);
    }

    public void setGetter(GetterMemberRef getter, TypeMemberPriority priority) {
        this.getter = this.getter != null ? this.getter.resolve(new TypeMember<GetterMemberRef>(priority, getter)) : new TypeMember<GetterMemberRef>(priority, getter);
    }

    public void setSetter(SetterMemberRef setter, TypeMemberPriority priority) {
        this.setter = this.setter != null ? this.setter.resolve(new TypeMember<SetterMemberRef>(priority, setter)) : new TypeMember<SetterMemberRef>(priority, setter);
    }

    public void addMethod(FunctionalMemberRef method, TypeMemberPriority priority) {
        this.methods.add(new TypeMember<FunctionalMemberRef>(priority, method));
    }

    public Expression getter(CodePosition position, TypeScope scope, Expression target, boolean allowStaticUsage) throws CompileException {
        if (this.getter != null) {
            if (((GetterMemberRef)this.getter.member).isStatic()) {
                if (!allowStaticUsage) {
                    return new InvalidExpression(position, ((GetterMemberRef)this.getter.member).getType(), CompileExceptionCode.USING_STATIC_ON_INSTANCE, "This field is static");
                }
                return ((GetterMemberRef)this.getter.member).getStatic(position);
            }
            scope.getPreparer().prepare(((GetterMemberRef)this.getter.member).member);
            return ((GetterMemberRef)this.getter.member).get(position, target);
        }
        if (this.field != null) {
            if (((FieldMemberRef)this.field.member).isStatic()) {
                if (!allowStaticUsage) {
                    return new InvalidExpression(position, ((FieldMemberRef)this.field.member).getType(), CompileExceptionCode.USING_STATIC_ON_INSTANCE, "This field is static");
                }
                return new GetStaticFieldExpression(position, (FieldMemberRef)this.field.member);
            }
            scope.getPreparer().prepare(((FieldMemberRef)this.field.member).member);
            return new GetFieldExpression(position, target, (FieldMemberRef)this.field.member);
        }
        throw new CompileException(position, CompileExceptionCode.MEMBER_NO_GETTER, "Value is not a property");
    }

    public Expression setter(CodePosition position, TypeScope scope, Expression target, Expression value, boolean allowStaticUsage) throws CompileException {
        if (this.setter != null) {
            if (((SetterMemberRef)this.setter.member).isStatic()) {
                if (!allowStaticUsage) {
                    return new InvalidExpression(position, ((SetterMemberRef)this.setter.member).getType(), CompileExceptionCode.USING_STATIC_ON_INSTANCE, "This field is static");
                }
                scope.getPreparer().prepare(((SetterMemberRef)this.setter.member).member);
                return new StaticSetterExpression(position, (SetterMemberRef)this.setter.member, value.castImplicit(position, scope, ((SetterMemberRef)this.setter.member).getType()));
            }
            scope.getPreparer().prepare(((SetterMemberRef)this.setter.member).member);
            return new SetterExpression(position, target, (SetterMemberRef)this.setter.member, value.castImplicit(position, scope, ((SetterMemberRef)this.setter.member).getType()));
        }
        if (this.field != null) {
            if (((FieldMemberRef)this.field.member).isStatic()) {
                if (!allowStaticUsage) {
                    return new InvalidExpression(position, ((FieldMemberRef)this.field.member).getType(), CompileExceptionCode.USING_STATIC_ON_INSTANCE, "This field is static");
                }
                scope.getPreparer().prepare(((FieldMemberRef)this.field.member).member);
                return new SetStaticFieldExpression(position, (FieldMemberRef)this.field.member, value.castImplicit(position, scope, ((FieldMemberRef)this.field.member).getType()));
            }
            scope.getPreparer().prepare(((FieldMemberRef)this.field.member).member);
            return new SetFieldExpression(position, target, (FieldMemberRef)this.field.member, value.castImplicit(position, scope, ((FieldMemberRef)this.field.member).getType()));
        }
        throw new CompileException(position, CompileExceptionCode.MEMBER_NO_SETTER, "Value is not settable");
    }

    public Expression staticGetter(CodePosition position, TypeScope scope) throws CompileException {
        if (this.constant != null) {
            return new ConstExpression(position, (ConstMemberRef)this.constant.member);
        }
        if (this.getter != null) {
            if (!((GetterMemberRef)this.getter.member).isStatic()) {
                return new InvalidExpression(position, ((GetterMemberRef)this.getter.member).getType(), CompileExceptionCode.MEMBER_NOT_STATIC, "This getter is not static");
            }
            scope.getPreparer().prepare(((GetterMemberRef)this.getter.member).member);
            return ((GetterMemberRef)this.getter.member).getStatic(position);
        }
        if (this.field != null) {
            if (!((FieldMemberRef)this.field.member).isStatic()) {
                return new InvalidExpression(position, ((FieldMemberRef)this.field.member).getType(), CompileExceptionCode.MEMBER_NOT_STATIC, "This field is not static");
            }
            scope.getPreparer().prepare(((FieldMemberRef)this.field.member).member);
            return new GetStaticFieldExpression(position, (FieldMemberRef)this.field.member);
        }
        throw new CompileException(position, CompileExceptionCode.MEMBER_NO_GETTER, "Member is not gettable");
    }

    public Expression staticSetter(CodePosition position, TypeScope scope, Expression value) throws CompileException {
        if (this.getter != null) {
            if (!((GetterMemberRef)this.getter.member).isStatic()) {
                return new InvalidExpression(position, ((GetterMemberRef)this.getter.member).getType(), CompileExceptionCode.MEMBER_NOT_STATIC, "This getter is not static");
            }
            scope.getPreparer().prepare(((SetterMemberRef)this.setter.member).member);
            return new StaticSetterExpression(position, (SetterMemberRef)this.setter.member, value.castImplicit(position, scope, ((SetterMemberRef)this.setter.member).getType()));
        }
        if (this.field != null) {
            if (!((FieldMemberRef)this.field.member).isStatic()) {
                return new InvalidExpression(position, ((FieldMemberRef)this.field.member).getType(), CompileExceptionCode.MEMBER_NOT_STATIC, "This field is not static");
            }
            scope.getPreparer().prepare(((FieldMemberRef)this.field.member).member);
            return new SetStaticFieldExpression(position, (FieldMemberRef)this.field.member, value.castImplicit(position, scope, ((FieldMemberRef)this.field.member).getType()));
        }
        throw new CompileException(position, CompileExceptionCode.MEMBER_NO_SETTER, "Member is not settable");
    }

    public List<StoredType>[] predictCallTypes(CodePosition position, TypeScope scope, List<StoredType> typeHints, int arguments) {
        List[] result = new List[arguments];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ArrayList();
        }
        for (TypeMember<FunctionalMemberRef> method : this.methods) {
            FunctionHeader header = ((FunctionalMemberRef)method.member).getHeader();
            if (header.parameters.length != arguments) continue;
            if (header.typeParameters != null) {
                for (StoredType resultHint : typeHints) {
                    Map<TypeParameter, StoredType> mapping = header.getReturnType().inferTypeParameters(scope.getMemberCache(), resultHint);
                    if (mapping == null) continue;
                    header = header.withGenericArguments(scope.getLocalTypeParameters().getInner(position, scope.getTypeRegistry(), mapping));
                    break;
                }
            }
            for (int i = 0; i < header.parameters.length; ++i) {
                if (result[i].contains(header.parameters[i].type)) continue;
                result[i].add(header.parameters[i].type);
            }
        }
        return result;
    }

    public Expression call(CodePosition position, TypeScope scope, Expression target, CallArguments arguments, boolean allowStaticUsage) throws CompileException {
        FunctionalMemberRef method = this.selectMethod(position, scope, arguments, true, allowStaticUsage);
        FunctionHeader instancedHeader = method.getHeader().fillGenericArguments(position, scope, arguments.typeArguments);
        boolean isVariadicCall = instancedHeader.isVariadicCall(arguments, scope);
        for (int i = 0; i < arguments.arguments.length; ++i) {
            arguments.arguments[i] = arguments.arguments[i].castImplicit(position, scope, instancedHeader.getParameterType(isVariadicCall, i));
        }
        scope.getPreparer().prepare(method.getTarget());
        return method.call(position, target, instancedHeader, arguments, scope);
    }

    public Expression callPostfix(CodePosition position, TypeScope scope, Expression target) throws CompileException {
        if (this.methods.isEmpty()) {
            throw new CompileException(position, CompileExceptionCode.NO_SUCH_MEMBER, "There is no such operator");
        }
        FunctionalMemberRef method = (FunctionalMemberRef)this.methods.get((int)0).member;
        if (!method.isOperator()) {
            throw new CompileException(position, CompileExceptionCode.NO_SUCH_MEMBER, "Member is not an operator");
        }
        scope.getPreparer().prepare(method.getTarget());
        return new PostCallExpression(position, target, method, method.getHeader());
    }

    public Expression callWithComparator(CodePosition position, TypeScope scope, Expression target, CallArguments arguments, CompareType compareType) throws CompileException {
        FunctionalMemberRef method = this.selectMethod(position, scope, arguments, true, false);
        FunctionHeader instancedHeader = method.getHeader().fillGenericArguments(position, scope, arguments.typeArguments);
        return method.callWithComparator(position, compareType, target, instancedHeader, arguments, scope);
    }

    public Expression callStatic(CodePosition position, TypeID target, TypeScope scope, CallArguments arguments) throws CompileException {
        FunctionalMemberRef method = this.selectMethod(position, scope, arguments, false, true);
        FunctionHeader instancedHeader = method.getHeader().fillGenericArguments(position, scope, arguments.typeArguments);
        return method.callStatic(position, target, instancedHeader, arguments, scope);
    }

    public FunctionalMemberRef selectMethod(CodePosition position, TypeScope scope, CallArguments arguments, boolean allowNonStatic, boolean allowStatic) throws CompileException {
        ArrayList<TypeMember<FunctionalMemberRef>> possibleMethods = new ArrayList<TypeMember<FunctionalMemberRef>>();
        for (TypeMember<FunctionalMemberRef> typeMember : this.methods) {
            FunctionHeader functionHeader;
            if (!(((FunctionalMemberRef)typeMember.member).isStatic() ? allowStatic : allowNonStatic) || !(functionHeader = ((FunctionalMemberRef)typeMember.member).getHeader().instanceForCall(position, scope.getTypeRegistry(), arguments)).matchesExactly(position, arguments, scope)) continue;
            possibleMethods.add(typeMember);
        }
        if (!possibleMethods.isEmpty()) {
            TypeMember selectedMethod = null;
            for (TypeMember typeMember : possibleMethods) {
                if (selectedMethod == null) {
                    selectedMethod = typeMember;
                    continue;
                }
                selectedMethod = selectedMethod.resolve(typeMember);
            }
            if (selectedMethod != null) {
                return (FunctionalMemberRef)selectedMethod.member;
            }
        }
        TypeMember<FunctionalMemberRef> selected = null;
        for (TypeMember<FunctionalMemberRef> typeMember : this.methods) {
            if (!(((FunctionalMemberRef)typeMember.member).isStatic() ? allowStatic : allowNonStatic) || arguments.arguments.length < ((FunctionalMemberRef)typeMember.member).getHeader().minParameters || arguments.arguments.length > ((FunctionalMemberRef)typeMember.member).getHeader().maxParameters) continue;
            scope.getPreparer().prepare(((FunctionalMemberRef)typeMember.member).getTarget());
            FunctionHeader header = ((FunctionalMemberRef)typeMember.member).getHeader().instanceForCall(position, scope.getTypeRegistry(), arguments);
            if (!header.matchesImplicitly(position, arguments, scope)) continue;
            if (selected == null) {
                selected = typeMember;
                continue;
            }
            if (selected.priority == typeMember.priority) {
                StringBuilder explanation = new StringBuilder();
                FunctionHeader selectedHeader = ((FunctionalMemberRef)selected.member).getHeader().instanceForCall(position, scope.getTypeRegistry(), arguments);
                explanation.append("Function A: ").append(selectedHeader.toString()).append("\n");
                explanation.append("Function B: ").append(header.toString());
                throw new CompileException(position, CompileExceptionCode.CALL_AMBIGUOUS, "Ambiguous call; multiple methods match:\n" + explanation.toString());
            }
            selected = selected.resolve(typeMember);
        }
        if (selected == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.methods.isEmpty()) {
                throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, "This type has no " + this.name);
            }
            for (TypeMember<FunctionalMemberRef> method : this.methods) {
                if (!(!((FunctionalMemberRef)method.member).isStatic() ? allowNonStatic : allowStatic)) {
                    stringBuilder.append(((FunctionalMemberRef)method.member).isStatic() ? "Method must not be static" : "Method must be static").append('\n');
                    continue;
                }
                FunctionHeader instancedHeader = ((FunctionalMemberRef)method.member).getHeader().instanceForCall(position, scope.getTypeRegistry(), arguments);
                stringBuilder.append(instancedHeader.explainWhyIncompatible(scope, arguments)).append("\n");
            }
            throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, "No matching method found for " + this.name + ":\n" + stringBuilder.toString());
        }
        return (FunctionalMemberRef)selected.member;
    }

    public FunctionalMemberRef getOverride(CodePosition position, TypeScope scope, FunctionalMember member) throws CompileException {
        ArrayList candidates = new ArrayList();
        for (TypeMember<FunctionalMemberRef> method : this.methods) {
            if (!member.header.canOverride(scope, ((FunctionalMemberRef)method.member).getHeader())) continue;
            candidates.add(method.member);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (FunctionalMemberRef)candidates.get(0);
        }
        throw new CompileException(position, CompileExceptionCode.OVERRIDE_AMBIGUOUS, "Ambiguous override: has " + candidates.size() + " base candidates");
    }
}

