/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.wireless;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.container.GenericContainer;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class WirelessRouterSetup {
    public static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "xnet");
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "xnet");
    public static final DeferredRegister<TileEntityType<?>> TILES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "xnet");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = new DeferredRegister(ForgeRegistries.CONTAINERS, "xnet");
    public static final RegistryObject<BaseBlock> WIRELESS_ROUTER = BLOCKS.register("wireless_router", TileEntityWirelessRouter::createBlock);
    public static final RegistryObject<Item> WIRELESS_ROUTER_ITEM = ITEMS.register("wireless_router", () -> new BlockItem((Block)WIRELESS_ROUTER.get(), XNet.createStandardProperties()));
    public static final RegistryObject<TileEntityType<?>> TYPE_WIRELESS_ROUTER = TILES.register("wireless_router", () -> TileEntityType.Builder.func_223042_a(TileEntityWirelessRouter::new, (Block[])new Block[]{(Block)WIRELESS_ROUTER.get()}).func_206865_a(null));
    public static final RegistryObject<ContainerType<GenericContainer>> CONTAINER_WIRELESS_ROUTER = CONTAINERS.register("wireless_router", GenericContainer::createContainerType);
    public static final RegistryObject<BaseBlock> ANTENNA = BLOCKS.register("antenna", WirelessRouterSetup::createAntennaBlock);
    public static final RegistryObject<Item> ANTENNA_ITEM = ITEMS.register("antenna", () -> new BlockItem((Block)ANTENNA.get(), XNet.createStandardProperties()));
    public static final RegistryObject<BaseBlock> ANTENNA_BASE = BLOCKS.register("antenna_base", WirelessRouterSetup::createAntennaBaseBlock);
    public static final RegistryObject<Item> ANTENNA_BASE_ITEM = ITEMS.register("antenna_base", () -> new BlockItem((Block)ANTENNA_BASE.get(), XNet.createStandardProperties()));
    public static final RegistryObject<BaseBlock> ANTENNA_DISH = BLOCKS.register("antenna_dish", WirelessRouterSetup::createAntennaDishBlock);
    public static final RegistryObject<Item> ANTENNA_DISH_ITEM = ITEMS.register("antenna_dish", () -> new BlockItem((Block)ANTENNA_DISH.get(), XNet.createStandardProperties()));

    public static void register() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static BaseBlock createAntennaDishBlock() {
        return new BaseBlock(new BlockBuilder().info("message.xnet.shiftmessage").infoExtended("message.xnet.antenna_dish").infoExtendedParameter(stack -> Integer.toString((Integer)Config.wirelessRouterRfPerChannel[2].get()))){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    private static BaseBlock createAntennaBaseBlock() {
        return new BaseBlock(new BlockBuilder().info("message.xnet.shiftmessage").infoExtended("message.xnet.antenna_base")){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static BaseBlock createAntennaBlock() {
        return new BaseBlock(new BlockBuilder().info("message.xnet.shiftmessage").infoExtended("message.xnet.antenna").infoExtendedParameter(stack -> Integer.toString((Integer)Config.antennaTier1Range.get())).infoExtendedParameter(stack -> Integer.toString((Integer)Config.wirelessRouterRfPerChannel[0].get())).infoExtendedParameter(stack -> Integer.toString((Integer)Config.antennaTier2Range.get())).infoExtendedParameter(stack -> Integer.toString((Integer)Config.wirelessRouterRfPerChannel[1].get()))){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }
}

