/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.various.client;

import java.awt.Rectangle;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.GuiTools;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextPage;
import mcjty.lib.gui.widgets.Widget;
import mcjty.xnet.XNet;
import mcjty.xnet.setup.XNetMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class GuiXNetManual
extends GuiItemScreen {
    private int xSize = 400;
    private int ySize = 224;
    private Window window;
    private TextPage textPage;
    private Label pageLabel;
    private Button prevButton;
    private Button nextButton;
    public static int MANUAL_XNET = 3;
    private ResourceLocation manualText;
    public static String locatePage = null;
    private static final ResourceLocation manualXNetText = new ResourceLocation("xnet", "text/manual_xnet.txt");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");

    public GuiXNetManual(int manual) {
        super((ModBase)XNet.instance, XNetMessages.INSTANCE, 400, 224, 0, "xxx");
        if (manual == MANUAL_XNET) {
            this.manualText = manualXNetText;
        }
    }

    public void init() {
        super.init();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.textPage = new TextPage((ModBase)XNet.instance, this.minecraft, (Screen)this).setText(this.manualText).setArrowImage(iconGuiElements, 144, 0).setCraftingGridImage(iconGuiElements, 0, 192);
        this.prevButton = ((Button)new Button(this.minecraft, (Screen)this).setText("<")).addButtonEvent(parent -> {
            this.textPage.prevPage();
            this.window.setTextFocus((Widget)this.textPage);
        });
        this.pageLabel = (Label)new Label(this.minecraft, (Screen)this).setText("0 / 0");
        this.nextButton = ((Button)new Button(this.minecraft, (Screen)this).setText(">")).addButtonEvent(parent -> {
            this.textPage.nextPage();
            this.window.setTextFocus((Widget)this.textPage);
        });
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16)).addChild((Widget)this.prevButton)).addChild((Widget)this.pageLabel)).addChild((Widget)this.nextButton);
        Panel toplevel = (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout()).addChild((Widget)this.textPage)).addChild((Widget)buttonPanel);
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.setTextFocus((Widget)this.textPage);
        if (locatePage != null) {
            this.textPage.gotoNode(locatePage);
            locatePage = null;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean rc = super.mouseClicked(x, y, button);
        this.window.mouseClicked((int)x, (int)y, button);
        return rc;
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
        int index = this.textPage.getPageIndex();
        int count = this.textPage.getPageCount();
        this.pageLabel.setText(index + 1 + "/" + count);
        this.prevButton.setEnabled(index > 0);
        this.nextButton.setEnabled(index < count - 1);
        this.window.draw();
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int x = GuiTools.getRelativeX((Screen)this);
            int y = GuiTools.getRelativeY((Screen)this);
            int guiLeft = (this.width - this.xSize) / 2;
            int guiTop = (this.height - this.ySize) / 2;
            this.renderTooltip(tooltips, x - guiLeft, y - guiTop, this.minecraft.field_71466_p);
        }
    }
}

