/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableSetup;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.ToolType;

public abstract class GenericCableBlock
extends Block {
    public static final EnumProperty<ConnectorType> NORTH = EnumProperty.func_177709_a((String)"north", ConnectorType.class);
    public static final EnumProperty<ConnectorType> SOUTH = EnumProperty.func_177709_a((String)"south", ConnectorType.class);
    public static final EnumProperty<ConnectorType> WEST = EnumProperty.func_177709_a((String)"west", ConnectorType.class);
    public static final EnumProperty<ConnectorType> EAST = EnumProperty.func_177709_a((String)"east", ConnectorType.class);
    public static final EnumProperty<ConnectorType> UP = EnumProperty.func_177709_a((String)"up", ConnectorType.class);
    public static final EnumProperty<ConnectorType> DOWN = EnumProperty.func_177709_a((String)"down", ConnectorType.class);
    public static final EnumProperty<CableColor> COLOR = EnumProperty.func_177709_a((String)"color", CableColor.class);
    public static final ModelProperty<BlockState> FACADEID = new ModelProperty();
    private static VoxelShape[] shapeCache = null;
    private static final VoxelShape SHAPE_CABLE_NORTH = VoxelShapes.func_197873_a((double)0.4, (double)0.4, (double)0.0, (double)0.6, (double)0.6, (double)0.4);
    private static final VoxelShape SHAPE_CABLE_SOUTH = VoxelShapes.func_197873_a((double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6, (double)1.0);
    private static final VoxelShape SHAPE_CABLE_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_EAST = VoxelShapes.func_197873_a((double)0.6, (double)0.4, (double)0.4, (double)1.0, (double)0.6, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_UP = VoxelShapes.func_197873_a((double)0.4, (double)0.6, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_DOWN = VoxelShapes.func_197873_a((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)0.4, (double)0.6);
    private static final VoxelShape SHAPE_BLOCK_NORTH = VoxelShapes.func_197873_a((double)0.2, (double)0.2, (double)0.0, (double)0.8, (double)0.8, (double)0.1);
    private static final VoxelShape SHAPE_BLOCK_SOUTH = VoxelShapes.func_197873_a((double)0.2, (double)0.2, (double)0.9, (double)0.8, (double)0.8, (double)1.0);
    private static final VoxelShape SHAPE_BLOCK_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.2, (double)0.2, (double)0.1, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_EAST = VoxelShapes.func_197873_a((double)0.9, (double)0.2, (double)0.2, (double)1.0, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_UP = VoxelShapes.func_197873_a((double)0.2, (double)0.9, (double)0.2, (double)0.8, (double)1.0, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_DOWN = VoxelShapes.func_197873_a((double)0.2, (double)0.0, (double)0.2, (double)0.8, (double)0.1, (double)0.8);
    private final CableBlockType type;

    public GenericCableBlock(Material material, CableBlockType type) {
        super(Block.Properties.func_200945_a((Material)material).func_200943_b(1.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(0).harvestTool(ToolType.PICKAXE));
        this.makeShapes();
        this.type = type;
    }

    private int calculateShapeIndex(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        int l = ConnectorType.values().length;
        return ((((south.ordinal() * l + north.ordinal()) * l + west.ordinal()) * l + east.ordinal()) * l + up.ordinal()) * l + down.ordinal();
    }

    private void makeShapes() {
        if (shapeCache == null) {
            int length = ConnectorType.values().length;
            shapeCache = new VoxelShape[length * length * length * length * length * length];
            for (ConnectorType up : ConnectorType.VALUES) {
                for (ConnectorType down : ConnectorType.VALUES) {
                    for (ConnectorType north : ConnectorType.VALUES) {
                        for (ConnectorType south : ConnectorType.VALUES) {
                            for (ConnectorType east : ConnectorType.VALUES) {
                                for (ConnectorType west : ConnectorType.VALUES) {
                                    int idx = this.calculateShapeIndex(north, south, west, east, up, down);
                                    GenericCableBlock.shapeCache[idx] = this.makeShape(north, south, west, east, up, down);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private VoxelShape makeShape(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
        shape = this.combineShape(shape, north, SHAPE_CABLE_NORTH, SHAPE_BLOCK_NORTH);
        shape = this.combineShape(shape, south, SHAPE_CABLE_SOUTH, SHAPE_BLOCK_SOUTH);
        shape = this.combineShape(shape, west, SHAPE_CABLE_WEST, SHAPE_BLOCK_WEST);
        shape = this.combineShape(shape, east, SHAPE_CABLE_EAST, SHAPE_BLOCK_EAST);
        shape = this.combineShape(shape, up, SHAPE_CABLE_UP, SHAPE_BLOCK_UP);
        shape = this.combineShape(shape, down, SHAPE_CABLE_DOWN, SHAPE_BLOCK_DOWN);
        return shape;
    }

    private VoxelShape combineShape(VoxelShape shape, ConnectorType connectorType, VoxelShape cableShape, VoxelShape blockShape) {
        if (connectorType == ConnectorType.CABLE) {
            return VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)cableShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (connectorType == ConnectorType.BLOCK) {
            return VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)blockShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    private Item getItem(CableColor color) {
        switch (this.type) {
            case CABLE: {
                switch (color) {
                    case BLUE: {
                        return (Item)CableSetup.NETCABLE_BLUE.get();
                    }
                    case RED: {
                        return (Item)CableSetup.NETCABLE_RED.get();
                    }
                    case YELLOW: {
                        return (Item)CableSetup.NETCABLE_YELLOW.get();
                    }
                    case GREEN: {
                        return (Item)CableSetup.NETCABLE_GREEN.get();
                    }
                    case ROUTING: {
                        return (Item)CableSetup.NETCABLE_ROUTING.get();
                    }
                }
                break;
            }
            case CONNECTOR: {
                switch (color) {
                    case BLUE: {
                        return (Item)CableSetup.CONNECTOR_BLUE.get();
                    }
                    case RED: {
                        return (Item)CableSetup.CONNECTOR_RED.get();
                    }
                    case YELLOW: {
                        return (Item)CableSetup.CONNECTOR_YELLOW.get();
                    }
                    case GREEN: {
                        return (Item)CableSetup.CONNECTOR_GREEN.get();
                    }
                    case ROUTING: {
                        return (Item)CableSetup.CONNECTOR_ROUTING.get();
                    }
                }
                break;
            }
            case ADVANCED_CONNECTOR: {
                switch (color) {
                    case BLUE: {
                        return (Item)CableSetup.ADVANCED_CONNECTOR_BLUE.get();
                    }
                    case RED: {
                        return (Item)CableSetup.ADVANCED_CONNECTOR_RED.get();
                    }
                    case YELLOW: {
                        return (Item)CableSetup.ADVANCED_CONNECTOR_YELLOW.get();
                    }
                    case GREEN: {
                        return (Item)CableSetup.ADVANCED_CONNECTOR_GREEN.get();
                    }
                    case ROUTING: {
                        return (Item)CableSetup.ADVANCED_CONNECTOR_ROUTING.get();
                    }
                }
            }
        }
        return Items.field_190931_a;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.getItem((CableColor)((Object)state.func_177229_b(COLOR))));
    }

    @Nullable
    protected BlockState getMimicBlock(IBlockReader blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof IFacadeSupport) {
            return ((IFacadeSupport)te).getMimicBlock();
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (this.getMimicBlock(world, pos) != null) {
            return this.getMimicBlock(world, pos).func_215700_a(world, pos, context);
        }
        CableColor color = (CableColor)((Object)state.func_177229_b(COLOR));
        ConnectorType north = this.getConnectorType(color, world, pos, Direction.NORTH);
        ConnectorType south = this.getConnectorType(color, world, pos, Direction.SOUTH);
        ConnectorType west = this.getConnectorType(color, world, pos, Direction.WEST);
        ConnectorType east = this.getConnectorType(color, world, pos, Direction.EAST);
        ConnectorType up = this.getConnectorType(color, world, pos, Direction.UP);
        ConnectorType down = this.getConnectorType(color, world, pos, Direction.DOWN);
        int index = this.calculateShapeIndex(north, south, west, east, up, down);
        return shapeCache[index];
    }

    public boolean isAdvancedConnector() {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState blockState;
        this.originalOnBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            this.createCableSegment(world, pos, stack);
        }
        if (state != (blockState = this.calculateState((IWorld)world, pos, state))) {
            world.func_175656_a(pos, blockState);
        }
    }

    protected void originalOnBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void createCableSegment(World world, BlockPos pos, ItemStack stack) {
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.func_180495_p(pos).func_177229_b(COLOR));
        worldBlob.createCableSegment(pos, new ColorId(color.ordinal() + 1));
        blobData.save();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            this.unlinkBlock(world, pos);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void unlinkBlock(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{COLOR, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return super.func_220076_a(state, builder);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos current, BlockPos offset) {
        return this.calculateState(world, current, state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.calculateState((IWorld)world, pos, this.func_176223_P());
        System.out.println("state = " + state);
        return state;
    }

    @Nonnull
    public BlockState calculateState(IWorld world, BlockPos pos, BlockState state) {
        CableColor color = (CableColor)((Object)state.func_177229_b(COLOR));
        ConnectorType north = this.getConnectorType(color, (IBlockReader)world, pos, Direction.NORTH);
        ConnectorType south = this.getConnectorType(color, (IBlockReader)world, pos, Direction.SOUTH);
        ConnectorType west = this.getConnectorType(color, (IBlockReader)world, pos, Direction.WEST);
        ConnectorType east = this.getConnectorType(color, (IBlockReader)world, pos, Direction.EAST);
        ConnectorType up = this.getConnectorType(color, (IBlockReader)world, pos, Direction.UP);
        ConnectorType down = this.getConnectorType(color, (IBlockReader)world, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, (Comparable)((Object)north))).func_206870_a(SOUTH, (Comparable)((Object)south))).func_206870_a(WEST, (Comparable)((Object)west))).func_206870_a(EAST, (Comparable)((Object)east))).func_206870_a(UP, (Comparable)((Object)up))).func_206870_a(DOWN, (Comparable)((Object)down));
    }

    protected abstract ConnectorType getConnectorType(@Nonnull CableColor var1, IBlockReader var2, BlockPos var3, Direction var4);

    public static enum CableBlockType {
        CABLE,
        CONNECTOR,
        ADVANCED_CONNECTOR,
        FACADE;

    }
}

