/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.ModList;

public final class ForestrySupport {
    private static final String ID = "forestry";
    private static final String QUEEN_BEE = "forestry:bee_queen_ge";
    private static final String PRINCESS_BEE = "forestry:bee_princess_ge";
    private static final String DRONE_BEE = "forestry:bee_drone_ge";
    private static final String LARVAE_BEE = "forestry:bee_larvae_ge";
    private static final String SAPLING = "forestry:sapling";
    private static final String POLLEN = "forestry:pollen_fertile";
    private static final String BUTTERFLY = "forestry:butterfly_ge";
    private static final String SERUM = "forestry:serum_ge";
    private static final String CATERPILLAR = "forestry:caterpillar_ge";
    private static final String COCOON = "forestry:cocoon_ge";
    private static final String[] FORESTRY_NAMES = new String[]{"forestry:bee_queen_ge", "forestry:bee_princess_ge", "forestry:bee_drone_ge", "forestry:bee_larvae_ge", "forestry:sapling", "forestry:pollen_fertile", "forestry:butterfly_ge", "forestry:serum_ge", "forestry:caterpillar_ge", "forestry:cocoon_ge"};

    public static boolean isLoaded() {
        return ModList.get().isLoaded(ID);
    }

    public static boolean isBreedable(ItemStack item) {
        String itemName = item.func_77973_b().getRegistryName().toString();
        for (String forestryName : FORESTRY_NAMES) {
            if (!itemName.equals(forestryName)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack sanitize(ItemStack item, int flags) {
        CompoundNBT tagCompound = item.func_77978_p().func_74737_b();
        ArrayList<Tag> tagsToRemove = new ArrayList<Tag>();
        switch (item.func_77973_b().getRegistryName().toString()) {
            case "forestry:bee_queen_ge": 
            case "forestry:bee_princess_ge": {
                tagsToRemove.add(Tag.GEN);
            }
            case "forestry:bee_drone_ge": 
            case "forestry:bee_larvae_ge": {
                Collections.addAll(tagsToRemove, Tag.GENOME, Tag.MATE, Tag.HEALTH, Tag.IS_ANALYZED, Tag.MAX_HEALTH);
                item.func_77982_d(ForestrySupport.removeTags(tagsToRemove, tagCompound, flags));
                break;
            }
            case "forestry:sapling": 
            case "forestry:pollen_fertile": {
                Collections.addAll(tagsToRemove, Tag.GENOME, Tag.IS_ANALYZED);
                item.func_77982_d(ForestrySupport.removeTags(tagsToRemove, tagCompound, flags));
                break;
            }
            case "forestry:butterfly_ge": 
            case "forestry:serum_ge": 
            case "forestry:caterpillar_ge": 
            case "forestry:cocoon_ge": {
                Collections.addAll(tagsToRemove, Tag.GENOME, Tag.MATE, Tag.HEALTH, Tag.IS_ANALYZED, Tag.MAX_HEALTH, Tag.AGE);
                item.func_77982_d(ForestrySupport.removeTags(tagsToRemove, tagCompound, flags));
                break;
            }
            default: {
                throw new IllegalArgumentException("Tried to sanitize \"" + item.func_77973_b().getRegistryName().toString() + "\" for Forestry!");
            }
        }
        return item;
    }

    private static CompoundNBT removeTags(ArrayList<Tag> tagsToRemove, CompoundNBT compound, int flags) {
        for (Tag tag : tagsToRemove) {
            if ((flags & tag.flag) != tag.flag || !compound.func_74764_b(tag.name)) continue;
            compound.func_82580_o(tag.name);
        }
        return compound;
    }

    public static enum Tag {
        GENOME("Genome", 1),
        MATE("Mate", 2),
        GEN("GEN", 4),
        HEALTH("Health", 8),
        IS_ANALYZED("IsAnalyzed", 16),
        MAX_HEALTH("MaxH", 32),
        AGE("Age", 64);

        private String name;
        private int flag;

        private Tag(String name, int flag) {
            this.name = name;
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

