/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.network.PacketGetPlayers;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.energy.CapabilityEnergy;

public class GuiMatterTransmitter
extends GenericGuiContainer<MatterTransmitterTileEntity, GenericContainer> {
    public static final int MATTER_WIDTH = 180;
    public static final int MATTER_HEIGHT = 160;
    public static final String ACCESS_PRIVATE = "Private";
    public static final String ACCESS_PUBLIC = "Public";
    private EnergyBar energyBar;
    private ChoiceLabel privateSetting;
    private WidgetList allowedPlayers;
    private Button addButton;
    private Button delButton;
    private TextField nameField;
    private List<String> players = null;
    private int listDirty = 0;
    private static Set<String> fromServer_allowedPlayers = new HashSet<String>();

    public static void storeAllowedPlayersForClient(List<String> players) {
        fromServer_allowedPlayers = new HashSet<String>(players);
    }

    public GuiMatterTransmitter(MatterTransmitterTileEntity transmitterTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsUtility.instance, (GenericTileEntity)transmitterTileEntity, (Container)container, inventory, 0, "tptransmitter");
        this.field_146999_f = 180;
        this.field_147000_g = 160;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.minecraft, (Screen)this).setFilledRectThickness(1)).setHorizontal().setDesiredHeight(12)).setDesiredWidth(80)).setShowText(false);
        TextField textField = (TextField)((TextField)new TextField(this.minecraft, (Screen)this).setName("name")).setTooltips(new String[]{"Use this name to", "identify this transmitter", "in the dialer"});
        Panel namePanel = (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new Label(this.minecraft, (Screen)this).setText("Name:"))).addChild((Widget)textField)).setDesiredHeight(16);
        this.privateSetting = ((ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.minecraft, (Screen)this).setName("private")).addChoices(new String[]{ACCESS_PUBLIC, ACCESS_PRIVATE}).setDesiredHeight(14)).setDesiredWidth(60)).setChoiceTooltip(ACCESS_PUBLIC, new String[]{"Everyone can access this transmitter", "and change the dialing destination"}).setChoiceTooltip(ACCESS_PRIVATE, new String[]{"Only people in the access list below", "can access this transmitter"});
        ToggleButton beamToggle = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.minecraft, (Screen)this).setName("beam")).setText("Hide")).setCheckMarker(true).setDesiredHeight(14)).setDesiredWidth(49)).setTooltips(new String[]{"Hide the teleportation beam"});
        Panel privatePanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new Label(this.minecraft, (Screen)this).setText("Access:"))).addChild((Widget)this.privateSetting)).addChild((Widget)beamToggle)).setDesiredHeight(16);
        this.allowedPlayers = (WidgetList)new WidgetList(this.minecraft, (Screen)this).setName("allowedplayers");
        Slider allowedPlayerSlider = ((Slider)new Slider(this.minecraft, (Screen)this).setDesiredWidth(10)).setVertical().setScrollableName("allowedplayers");
        Panel allowedPlayersPanel = (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.allowedPlayers)).addChild((Widget)allowedPlayerSlider)).setFilledBackground(-6381922);
        this.nameField = new TextField(this.minecraft, (Screen)this);
        this.addButton = (Button)((Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("addplayer")).setText("Add")).setDesiredHeight(13)).setDesiredWidth(34)).setTooltips(new String[]{"Add a player to the access list"});
        this.delButton = (Button)((Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setChannel("delplayer")).setText("Del")).setDesiredHeight(13)).setDesiredWidth(34)).setTooltips(new String[]{"Remove the selected player", "from the access list"});
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.nameField)).addChild((Widget)this.addButton)).addChild((Widget)this.delButton)).setDesiredHeight(16);
        Panel toplevel = (Panel)((Panel)new Panel(this.minecraft, (Screen)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setHorizontalMargin(3)).setVerticalMargin(3)).setSpacing(1)).addChildren(new Widget[]{this.energyBar, namePanel, privatePanel, allowedPlayersPanel, buttonPanel});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 180, 160));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.minecraft.field_195559_v.func_197967_a(true);
        this.listDirty = 0;
        this.requestPlayers();
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "name", this.tileEntity, MatterTransmitterTileEntity.VALUE_NAME.getName());
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "private", this.tileEntity, MatterTransmitterTileEntity.VALUE_PRIVATE.getName());
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "beam", this.tileEntity, MatterTransmitterTileEntity.VALUE_BEAM.getName());
        this.window.event("addplayer", (source, params) -> this.addPlayer());
        this.window.event("delplayer", (source, params) -> this.delPlayer());
    }

    private void addPlayer() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "transmitter.addPlayer", TypedMap.builder().put(MatterTransmitterTileEntity.PARAM_PLAYER, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "transmitter.delPlayer", TypedMap.builder().put(MatterTransmitterTileEntity.PARAM_PLAYER, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void requestPlayers() {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetPlayers(((MatterTransmitterTileEntity)this.tileEntity).func_174877_v(), "getPlayers", "getPlayers"));
    }

    private void populatePlayers() {
        ArrayList<String> newPlayers = new ArrayList<String>(fromServer_allowedPlayers);
        Collections.sort(newPlayers);
        if (newPlayers.equals(this.players)) {
            return;
        }
        this.players = new ArrayList<String>(newPlayers);
        this.allowedPlayers.removeChildren();
        for (String player : this.players) {
            this.allowedPlayers.addChild((Widget)((Label)((Label)new Label(this.minecraft, (Screen)this).setColor(StyleConfig.colorTextInListNormal)).setText(player)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        this.drawWindow();
        ((MatterTransmitterTileEntity)this.tileEntity).getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
            this.energyBar.setMaxValue(((GenericEnergyStorage)e).getCapacity());
            this.energyBar.setValue(((GenericEnergyStorage)e).getEnergy());
        });
    }

    private void enableButtons() {
        boolean isPrivate = ACCESS_PRIVATE.equals(this.privateSetting.getCurrentChoice());
        this.allowedPlayers.setEnabled(isPrivate);
        this.nameField.setEnabled(isPrivate);
        int isPlayerSelected = this.allowedPlayers.getSelected();
        this.delButton.setEnabled(isPrivate && isPlayerSelected != -1);
        String name = this.nameField.getText();
        this.addButton.setEnabled(isPrivate && name != null && !name.isEmpty());
    }
}

