/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import mcjty.lib.blocks.BaseBlockItem;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class SimpleDialerItemBlock
extends BaseBlockItem {
    public SimpleDialerItemBlock(Block block) {
        super(block, new Item.Properties().func_200916_a(RFToolsUtility.setup.getTab()));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        TileEntity te = world.func_175625_s(pos);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (te instanceof MatterTransmitterTileEntity) {
            if (!world.field_72995_K) {
                MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
                if (!matterTransmitterTileEntity.checkAccess(player.func_200200_C_().func_150254_d())) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to this matter transmitter!"));
                    return ActionResultType.FAIL;
                }
                tagCompound.func_74768_a("transX", matterTransmitterTileEntity.func_174877_v().func_177958_n());
                tagCompound.func_74768_a("transY", matterTransmitterTileEntity.func_174877_v().func_177956_o());
                tagCompound.func_74768_a("transZ", matterTransmitterTileEntity.func_174877_v().func_177952_p());
                tagCompound.func_74768_a("transDim", world.func_201675_m().func_186058_p().func_186068_a());
                if (matterTransmitterTileEntity.isDialed()) {
                    Integer id = matterTransmitterTileEntity.getTeleportId();
                    boolean access = this.checkReceiverAccess(player, world, id);
                    if (!access) {
                        Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to the matter receiver!"));
                        return ActionResultType.FAIL;
                    }
                    tagCompound.func_74768_a("receiver", id.intValue());
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Receiver set!"));
                }
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Transmitter set!"));
            }
        } else if (te instanceof MatterReceiverTileEntity) {
            if (!world.field_72995_K) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                Integer id = matterReceiverTileEntity.getOrCalculateID();
                boolean access = this.checkReceiverAccess(player, world, id);
                if (!access) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to this matter receiver!"));
                    return ActionResultType.FAIL;
                }
                tagCompound.func_74768_a("receiver", id.intValue());
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Receiver set!"));
            }
        } else {
            return super.func_195939_a(context);
        }
        stack.func_77982_d(tagCompound);
        return ActionResultType.SUCCESS;
    }

    private boolean checkReceiverAccess(PlayerEntity player, World world, Integer id) {
        MatterReceiverTileEntity matterReceiverTileEntity;
        TileEntity recTe;
        World worldForDimension;
        TeleportDestination destination;
        boolean access = true;
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalCoordinate coordinate = destinations.getCoordinateForId(id);
        if (coordinate != null && (destination = destinations.getDestination(coordinate)) != null && (worldForDimension = TeleportationTools.getWorldForDimension((DimensionType)destination.getDimension())) != null && (recTe = worldForDimension.func_175625_s(destination.getCoordinate())) instanceof MatterReceiverTileEntity && !(matterReceiverTileEntity = (MatterReceiverTileEntity)recTe).checkAccess(player.func_110124_au())) {
            access = false;
        }
        return access;
    }
}

