/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MatterReceiverBlock
extends BaseBlock {
    public MatterReceiverBlock() {
        super(new BlockBuilder().tileEntitySupplier(MatterReceiverTileEntity::new));
    }

    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(itemStack, world, list, flag);
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String name = tagCompound.func_74779_i("tpName");
            int id = tagCompound.func_74762_e("destinationId");
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Name: " + name + (id == -1 ? "" : ", Id: " + id)));
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "If you place this block anywhere in the world then"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "you can dial to it using a Dialing Device. Before"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "teleporting to this block make sure to give it power!"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return state;
        }
        TeleportDestinations destinations = TeleportDestinations.get(world);
        BlockPos pos = context.func_195995_a();
        GlobalCoordinate gc = new GlobalCoordinate(pos, world.func_201675_m().func_186058_p());
        destinations.getNewId(gc);
        destinations.addDestination(gc);
        destinations.save();
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)world.func_175625_s(pos);
            matterReceiverTileEntity.getOrCalculateID();
            matterReceiverTileEntity.updateDestination();
        }
        this.setOwner(world, pos, placer);
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        super.func_196243_a(state, world, pos, newstate, isMoving);
        if (world.field_72995_K) {
            return;
        }
        TeleportDestinations destinations = TeleportDestinations.get(world);
        destinations.removeDestination(pos, world.func_201675_m().func_186058_p());
        destinations.save();
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }
}

