/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenLevelHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;

public class ClientScreenModuleHelper
implements IModuleRenderHelper {
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public void renderLevel(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontRenderer, int xoffset, int currenty, IModuleDataContents screenData, String label, boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff, int poscolor, int negcolor, int gradient1, int gradient2, FormatStyle formatStyle) {
        this.renderLevel(matrixStack, buffer, fontRenderer, xoffset, currenty, screenData, label, hidebar, hidetext, showpct, showdiff, poscolor, negcolor, gradient1, gradient2, formatStyle, null);
    }

    private void renderLevel(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontRenderer, int xoffset, int currenty, IModuleDataContents screenData, String label, boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff, int poscolor, int negcolor, int gradient1, int gradient2, FormatStyle formatStyle, ModuleRenderInfo renderInfo) {
        if (screenData == null) {
            return;
        }
        long maxContents = screenData.getMaxContents();
        if (maxContents > 0L && !hidebar) {
            int width;
            long contents = screenData.getContents();
            long value = contents * (long)(width = 80 - xoffset + 7 + 40) / maxContents;
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)width) {
                value = width;
            }
            RenderHelper.drawHorizontalGradientRect((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)xoffset, (int)currenty, (int)((int)((long)xoffset + value)), (int)(currenty + 8), (int)gradient1, (int)gradient2, (int)renderInfo.getLightmapValue());
        }
        if (!hidetext) {
            String diffTxt = null;
            int col = poscolor;
            if (showdiff) {
                long diff = screenData.getLastPerTick();
                if (diff < 0L) {
                    col = negcolor;
                    diffTxt = diff + " " + label + "/t";
                } else {
                    diffTxt = "+" + diff + " " + label + "/t";
                }
            } else if (maxContents > 0L) {
                long contents = screenData.getContents();
                if (showpct) {
                    long value = contents * 100L / maxContents;
                    if (value < 0L) {
                        value = 0L;
                    } else if (value > 100L) {
                        value = 100L;
                    }
                    diffTxt = value + "%";
                } else {
                    diffTxt = this.format(String.valueOf(contents), formatStyle) + label;
                }
            }
            if (diffTxt != null) {
                ScreenTextHelper.renderScaled(matrixStack, buffer, diffTxt, xoffset, currenty, col, (Boolean)ScreenConfiguration.useTruetype.get(), renderInfo.getLightmapValue());
            }
        }
    }

    public ITextRenderHelper createTextRenderHelper() {
        return new ScreenTextHelper();
    }

    public ILevelRenderHelper createLevelRenderHelper() {
        return new ScreenLevelHelper();
    }

    public void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x, int y, int color, @Nonnull ModuleRenderInfo renderInfo, String text) {
        if (text == null) {
            return;
        }
        ScreenTextHelper.renderScaled(matrixStack, buffer, text, x, y, color, renderInfo.truetype, renderInfo.getLightmapValue());
    }

    public void renderTextTrimmed(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x, int y, int color, @Nonnull ModuleRenderInfo renderInfo, String text, int maxwidth) {
        if (text == null) {
            return;
        }
        ScreenTextHelper.renderScaledTrimmed(matrixStack, buffer, text, x, y, maxwidth / 4, color, renderInfo.truetype, renderInfo.getLightmapValue());
    }

    public String format(String in, FormatStyle style) {
        switch (style) {
            case MODE_FULL: {
                return in;
            }
            case MODE_COMPACT: {
                long contents = Long.parseLong(in);
                int unit = 1000;
                if (contents < (long)unit) {
                    return in;
                }
                int exp = (int)(Math.log(contents) / Math.log(unit));
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)contents / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case MODE_COMMAS: {
                return dfCommas.format(Long.parseLong(in));
            }
        }
        return in;
    }
}

