/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class TextClientScreenModule
implements IClientScreenModule<IModuleData> {
    private String line = "";
    private int color = 0xFFFFFF;
    private ITextRenderHelper cache = new ScreenTextHelper();

    public IClientScreenModule.TransformMode getTransformMode() {
        return this.cache.isLarge() ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return this.cache.isLarge() ? 20 : 10;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        this.cache.setup(this.line, 512, renderInfo);
        int y = this.cache.isLarge() ? currenty / 2 + 1 : currenty;
        this.cache.renderText(matrixStack, buffer, 0, y, this.color, renderInfo);
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setLine(String line) {
        this.line = line;
        this.cache.setDirty();
    }

    public void setColor(int color) {
        this.color = color;
        this.cache.setDirty();
    }

    public void setLarge(boolean large) {
        this.cache.large(large);
        this.cache.setDirty();
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.cache.large(tagCompound.func_74767_n("large"));
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.cache.align(TextAlign.get((String)alignment));
            } else {
                this.cache.align(TextAlign.ALIGN_LEFT);
            }
        }
    }

    public boolean needsServerData() {
        return false;
    }
}

