/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenLevelHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class FluidBarClientScreenModule
implements IClientScreenModule<IModuleDataContents> {
    private String line = "";
    private int color = 0xFFFFFF;
    protected DimensionType dim = DimensionType.field_223227_a_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private ITextRenderHelper labelCache = new ScreenTextHelper();
    private ILevelRenderHelper mbRenderer = new ScreenLevelHelper().gradient(-16742145, -16764109);

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataContents screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(matrixStack, buffer, 0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            this.mbRenderer.render(matrixStack, buffer, xoffset, currenty, screenData, renderInfo);
        } else {
            renderHelper.renderText(matrixStack, buffer, xoffset, currenty, -65536, renderInfo, "<invalid>");
        }
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            int mbcolorNeg = 0xFFFFFF;
            int mbcolor = tagCompound.func_74764_b("mbcolor") ? tagCompound.func_74762_e("mbcolor") : 0xFFFFFF;
            this.mbRenderer.color(mbcolor, mbcolorNeg);
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.labelCache.align(TextAlign.get((String)alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            boolean hidebar = tagCompound.func_74767_n("hidebar");
            boolean hidetext = tagCompound.func_74767_n("hidetext");
            boolean showdiff = tagCompound.func_74767_n("showdiff");
            boolean showpct = tagCompound.func_74767_n("showpct");
            this.mbRenderer.settings(hidebar, hidetext, showpct, showdiff);
            this.mbRenderer.format(FormatStyle.values()[tagCompound.func_74762_e("format")]);
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
            if (dim.equals(this.dim)) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

