/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class CounterClientScreenModule
implements IClientScreenModule<IModuleDataInteger> {
    private String line = "";
    private int color = 0xFFFFFF;
    private int cntcolor = 0xFFFFFF;
    protected DimensionType dim = DimensionType.field_223227_a_;
    private FormatStyle format = FormatStyle.MODE_FULL;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private ITextRenderHelper labelCache = new ScreenTextHelper();

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataInteger screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(matrixStack, buffer, 0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            int counter = screenData != null ? screenData.get() : 0;
            String output = renderHelper.format(String.valueOf(counter), this.format);
            renderHelper.renderText(matrixStack, buffer, xoffset, currenty, this.cntcolor, renderInfo, output);
        } else {
            renderHelper.renderText(matrixStack, buffer, xoffset, currenty, 0xFF0000, renderInfo, "<invalid>");
        }
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.cntcolor = tagCompound.func_74764_b("cntcolor") ? tagCompound.func_74762_e("cntcolor") : 0xFFFFFF;
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.labelCache.align(TextAlign.get((String)alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            this.format = FormatStyle.values()[tagCompound.func_74762_e("format")];
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

