/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class ItemStackScreenModule
implements IScreenModule<ModuleDataStacks> {
    private int slot1 = -1;
    private int slot2 = -1;
    private int slot3 = -1;
    private int slot4 = -1;
    protected DimensionType dim = DimensionType.field_223227_a_;
    protected BlockPos coordinate = BlockPosTools.INVALID;

    public ModuleDataStacks getData(IScreenDataHelper helper, World worldObj, long millis) {
        ServerWorld world = WorldTools.getWorld((World)worldObj, (DimensionType)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (te == null) {
            return null;
        }
        return (ModuleDataStacks)CapabilityTools.getItemCapabilitySafe((TileEntity)te).map(h -> {
            ItemStack stack1 = this.getItemStack((IItemHandler)h, this.slot1);
            ItemStack stack2 = this.getItemStack((IItemHandler)h, this.slot2);
            ItemStack stack3 = this.getItemStack((IItemHandler)h, this.slot3);
            ItemStack stack4 = this.getItemStack((IItemHandler)h, this.slot4);
            return new ModuleDataStacks(stack1, stack2, stack3, stack4);
        }).orElse(null);
    }

    private ItemStack getItemStack(IInventory inventory, int slot) {
        if (slot == -1) {
            return ItemStack.field_190927_a;
        }
        if (slot < inventory.func_70302_i_()) {
            return inventory.func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getItemStack(IItemHandler itemHandler, int slot) {
        if (slot == -1) {
            return ItemStack.field_190927_a;
        }
        if (slot < itemHandler.getSlots()) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.field_190927_a;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            if (tagCompound.func_74764_b("slot1")) {
                this.slot1 = tagCompound.func_74762_e("slot1");
            }
            if (tagCompound.func_74764_b("slot2")) {
                this.slot2 = tagCompound.func_74762_e("slot2");
            }
            if (tagCompound.func_74764_b("slot3")) {
                this.slot3 = tagCompound.func_74762_e("slot3");
            }
            if (tagCompound.func_74764_b("slot4")) {
                this.slot4 = tagCompound.func_74762_e("slot4");
            }
        }
    }

    protected void setupCoordinateFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.ITEMSTACK_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftoolsutility:itemStacks";
        private final ItemStack[] stacks = new ItemStack[4];

        public String getId() {
            return ID;
        }

        public ModuleDataStacks(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
            this.stacks[0] = stack1;
            this.stacks[1] = stack2;
            this.stacks[2] = stack3;
            this.stacks[3] = stack4;
        }

        public ModuleDataStacks(PacketBuffer buf) {
            for (int i = 0; i < 4; ++i) {
                this.stacks[i] = NetworkTools.readItemStack((PacketBuffer)buf);
            }
        }

        public ItemStack getStack(int idx) {
            return this.stacks[idx];
        }

        public void writeToBuf(PacketBuffer buf) {
            this.writeStack(buf, this.stacks[0]);
            this.writeStack(buf, this.stacks[1]);
            this.writeStack(buf, this.stacks[2]);
            this.writeStack(buf, this.stacks[3]);
        }

        private void writeStack(PacketBuffer buf, ItemStack stack) {
            NetworkTools.writeItemStack((PacketBuffer)buf, (ItemStack)stack);
        }
    }
}

