/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items;

import java.util.Collection;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.RFToolsTools;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.StorageControlScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.StorageControlClientScreenModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class StorageControlModuleItem
extends Item
implements IModuleProvider,
INBTPreservingIngredient {
    public StorageControlModuleItem() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Uses " + ScreenConfiguration.STORAGE_CONTROL_RFPERTICK.get() + " RF/tick"));
        boolean hasTarget = false;
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            hasTarget = StorageControlModuleItem.addModuleInformation(list, itemStack);
        }
        if (!hasTarget) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Sneak right-click on a storage scanner to set the"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "target for this storage module"));
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This screen module allows you to monitor 9 different"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "items through a storage scanner."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This module can also be combined with a tablet"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "for remote access to a storage scanner controlled"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "system"));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    public static boolean addModuleInformation(List<ITextComponent> list, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Label: " + stack.func_77978_p().func_74779_i("text")));
        if (RFToolsTools.hasModuleTarget(stack)) {
            BlockPos pos = RFToolsTools.getPositionFromModule(stack);
            String monitorname = stack.func_77978_p().func_74779_i("monitorname");
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + BlockPosTools.toString((BlockPos)pos) + ")"));
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IStorageScanner) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockReader)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            RFToolsTools.setPositionInModule(stack, world.func_201675_m().func_186058_p(), pos, name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            RFToolsTools.clearPositionInModule(stack);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)"Storage module is cleared");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public Class<StorageControlScreenModule> getServerScreenModule() {
        return StorageControlScreenModule.class;
    }

    public Class<StorageControlClientScreenModule> getClientScreenModule() {
        return StorageControlClientScreenModule.class;
    }

    public String getModuleName() {
        return "Stor";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.ghostStack("stack0").ghostStack("stack1").ghostStack("stack2").nl().ghostStack("stack3").ghostStack("stack4").ghostStack("stack5").nl().ghostStack("stack6").ghostStack("stack7").ghostStack("stack8").nl().toggle("starred", "Starred", new String[]{"If enabled only count items", "in 'starred' inventories", "(mark inventories in storage scanner)"}).toggle("oredict", "Ore Dict", new String[]{"If enabled use ore dictionary", "to match items"}).nl().block("monitor").nl();
    }

    public Collection<String> getTagsToPreserve() {
        return null;
    }
}

