/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items;

import java.util.List;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.MachineInformationScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.MachineInformationClientScreenModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MachineInformationModuleItem
extends Item
implements IModuleProvider {
    private static final IModuleGuiBuilder.Choice[] EMPTY_CHOICES = new IModuleGuiBuilder.Choice[0];

    public MachineInformationModuleItem() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
    }

    public Class<MachineInformationScreenModule> getServerScreenModule() {
        return MachineInformationScreenModule.class;
    }

    public Class<MachineInformationClientScreenModule> getClientScreenModule() {
        return MachineInformationClientScreenModule.class;
    }

    public String getModuleName() {
        return "Info";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        TileEntity tileEntity;
        World world = guiBuilder.getWorld();
        CompoundNBT currentData = guiBuilder.getCurrentData();
        IModuleGuiBuilder.Choice[] choices = EMPTY_CHOICES;
        if (currentData.func_74779_i("monitordim").equals(world.func_201675_m().func_186058_p().getRegistryName().toString()) && (tileEntity = world.func_175625_s(new BlockPos(currentData.func_74762_e("monitorx"), currentData.func_74762_e("monitory"), currentData.func_74762_e("monitorz")))) != null) {
            choices = (IModuleGuiBuilder.Choice[])tileEntity.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY).map(h -> {
                int count = h.getTagCount();
                IModuleGuiBuilder.Choice[] cs = new IModuleGuiBuilder.Choice[count];
                for (int i = 0; i < count; ++i) {
                    cs[i] = new IModuleGuiBuilder.Choice(h.getTagName(i), new String[]{h.getTagDescription(i)});
                }
                return cs;
            }).orElse((Object)EMPTY_CHOICES);
        }
        guiBuilder.label("L:").color("color", new String[]{"Color for the label"}).label("Txt:").color("txtcolor", new String[]{"Color for the text"}).nl().choices("monitorTag", choices).nl().block("monitor").nl();
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Uses " + ScreenConfiguration.MACHINEINFO_RFPERTICK.get() + " RF/tick"));
        boolean hasTarget = false;
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text")));
            if (tagCompound.func_74764_b("monitorx")) {
                int monitorx = tagCompound.func_74762_e("monitorx");
                int monitory = tagCompound.func_74762_e("monitory");
                int monitorz = tagCompound.func_74762_e("monitorz");
                String monitorname = tagCompound.func_74779_i("monitorname");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")"));
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Sneak right-click on a supported machine"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "to set the target for this module"));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        TileEntity te = world.func_175625_s(pos);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (te != null && te.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY).isPresent()) {
            tagCompound.func_74778_a("monitordim", world.func_201675_m().func_186058_p().getRegistryName().toString());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            BlockState state = player.func_130014_f_().func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockReader)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Machine Information module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)"Machine Information module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return ActionResultType.SUCCESS;
    }
}

