/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items;

import java.util.List;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ItemStackPlusScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.ItemStackPlusClientScreenModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InventoryPlusModuleItem
extends Item
implements IModuleProvider {
    public InventoryPlusModuleItem() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Uses " + ScreenConfiguration.ITEMSTACK_RFPERTICK.get() + " RF/tick"));
        boolean hasTarget = false;
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text")));
            if (tagCompound.func_74764_b("monitorx")) {
                String dim = tagCompound.func_74779_i("monitordim");
                int monitorx = tagCompound.func_74762_e("monitorx");
                int monitory = tagCompound.func_74762_e("monitory");
                int monitorz = tagCompound.func_74762_e("monitorz");
                String monitorname = tagCompound.func_74779_i("monitorname");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")"));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Dimension: " + dim));
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Sneak right-click on an inventory to set the"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "target for this inventory module"));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "This is not a valid inventory!"));
            }
            return ActionResultType.SUCCESS;
        }
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (CapabilityTools.getItemCapabilitySafe((TileEntity)te).isPresent()) {
            tagCompound.func_74778_a("monitordim", world.func_201675_m().func_186058_p().getRegistryName().toString());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockReader)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Inventory module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)"Inventory module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return ActionResultType.SUCCESS;
    }

    public Class<ItemStackPlusScreenModule> getServerScreenModule() {
        return ItemStackPlusScreenModule.class;
    }

    public Class<ItemStackPlusClientScreenModule> getClientScreenModule() {
        return ItemStackPlusClientScreenModule.class;
    }

    public String getModuleName() {
        return "Inv";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Slot 1:").integer("slot1", new String[]{"Slot index to show"}).nl().label("Slot 2:").integer("slot2", new String[]{"Slot index to show"}).nl().label("Slot 3:").integer("slot3", new String[]{"Slot index to show"}).nl().label("Slot 4:").integer("slot4", new String[]{"Slot index to show"}).nl().block("monitor").nl();
    }
}

