/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenSetup;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ClientScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.network.PacketGetScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ScreenRenderer
extends TileEntityRenderer<ScreenTileEntity> {
    private ClientScreenModuleHelper clientScreenModuleHelper = new ClientScreenModuleHelper();

    public ScreenRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ScreenTileEntity tileEntity, float v, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLightIn, int packedOverlayIn) {
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        Direction facing = Direction.SOUTH;
        Direction horizontalFacing = Direction.SOUTH;
        if (tileEntity != null) {
            BlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(tileEntity.func_174877_v());
            if (state.func_177230_c() instanceof ScreenBlock) {
                facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                horizontalFacing = (Direction)state.func_177229_b((IProperty)ScreenBlock.HORIZ_FACING);
            } else {
                return;
            }
        }
        matrixStack.func_227860_a_();
        switch (horizontalFacing) {
            case NORTH: {
                yRotation = -180.0f;
                break;
            }
            case WEST: {
                yRotation = -90.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
            }
        }
        switch (facing) {
            case DOWN: {
                xRotation = 90.0f;
                break;
            }
            case UP: {
                xRotation = -90.0f;
            }
        }
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRotation));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(xRotation));
        matrixStack.func_227861_a_(0.0, 0.0, -0.4375);
        if (tileEntity == null) {
            this.renderScreenBoard(matrixStack, buffer, 0, 0, packedLightIn, packedOverlayIn);
        } else if (!tileEntity.isTransparent()) {
            this.renderScreenBoard(matrixStack, buffer, tileEntity.getSize(), tileEntity.getColor(), packedLightIn, packedOverlayIn);
        }
        if (tileEntity != null && tileEntity.isRenderable()) {
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            IClientScreenModule.TransformMode mode = IClientScreenModule.TransformMode.NONE;
            Map<Integer, IModuleData> screenData = this.updateScreenData(tileEntity);
            List<IClientScreenModule<?>> modules = tileEntity.getClientScreenModules();
            if (tileEntity.isShowHelp()) {
                modules = ScreenTileEntity.getHelpingScreenModules();
            }
            this.renderModules(matrixStack, buffer, fontrenderer, tileEntity, mode, modules, screenData, tileEntity.getSize());
        }
        matrixStack.func_227865_b_();
    }

    private Map<Integer, IModuleData> updateScreenData(ScreenTileEntity screenTileEntity) {
        GlobalCoordinate key;
        Map<Integer, Object> screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > (long)((Integer)ScreenConfiguration.SCREEN_REFRESH_TIMING.get()).intValue() && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            GlobalCoordinate pos = new GlobalCoordinate(screenTileEntity.func_174877_v(), screenTileEntity.func_145831_w().func_201675_m().func_186058_p());
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetScreenData("rftoolsutility", pos, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(key = new GlobalCoordinate(screenTileEntity.func_174877_v(), screenTileEntity.func_145831_w().func_201675_m().func_186058_p()))) == null) {
            screenData = Collections.emptyMap();
        }
        return screenData;
    }

    private void renderModules(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontrenderer, ScreenTileEntity tileEntity, IClientScreenModule.TransformMode mode, List<IClientScreenModule<?>> modules, Map<Integer, IModuleData> screenData, int size) {
        Direction horizontalFacing;
        double zz;
        double yy;
        double xx;
        Direction sideHit;
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        BlockPos pos = tileEntity.func_174877_v();
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        IClientScreenModule<?> hitModule = null;
        ScreenTileEntity.ModuleRaytraceResult hit = null;
        BlockState blockState = tileEntity.func_145831_w().func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != ScreenSetup.SCREEN.get() && block != ScreenSetup.CREATIVE_SCREEN.get() && block != ScreenSetup.SCREEN_HIT.get()) {
            return;
        }
        if (mouseOver instanceof BlockRayTraceResult && (sideHit = ((BlockRayTraceResult)mouseOver).func_216354_b()) == blockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H) && (hit = tileEntity.getHitModule(xx = mouseOver.func_216347_e().field_72450_a - (double)pos.func_177958_n(), yy = mouseOver.func_216347_e().field_72448_b - (double)pos.func_177956_o(), zz = mouseOver.func_216347_e().field_72449_c - (double)pos.func_177952_p(), sideHit, horizontalFacing = (Direction)blockState.func_177229_b((IProperty)ScreenBlock.HORIZ_FACING))) != null) {
            hitModule = modules.get(hit.getModuleIndex());
        }
        for (IClientScreenModule<?> module : modules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (module.getTransformMode() != mode) {
                    if (mode != IClientScreenModule.TransformMode.NONE) {
                        matrixStack.func_227865_b_();
                    }
                    matrixStack.func_227860_a_();
                    mode = module.getTransformMode();
                    switch (mode) {
                        case TEXT: {
                            matrixStack.func_227861_a_(-0.5, 0.5, (double)0.03f);
                            float f3 = 0.0075f;
                            matrixStack.func_227862_a_(f3 * factor, -f3 * factor, f3);
                            break;
                        }
                        case TEXTLARGE: {
                            matrixStack.func_227861_a_(-0.5, 0.5, (double)0.03f);
                            float f3 = 0.015f;
                            matrixStack.func_227862_a_(f3 * factor, -f3 * factor, f3);
                            break;
                        }
                        case ITEM: {
                            matrixStack.func_227861_a_(0.0, 0.0, (double)-0.04f);
                            break;
                        }
                    }
                }
                IModuleData data = screenData.get(moduleIndex);
                try {
                    int hitx = -1;
                    int hity = -1;
                    if (module == hitModule) {
                        hitx = hit.getX();
                        hity = hit.getY() - hit.getCurrenty();
                    }
                    boolean truetype = false;
                    switch (tileEntity.getTrueTypeMode()) {
                        case -1: {
                            break;
                        }
                        case 1: {
                            truetype = true;
                            break;
                        }
                        case 0: {
                            truetype = (Boolean)ScreenConfiguration.useTruetype.get();
                        }
                    }
                    ModuleRenderInfo renderInfo = new ModuleRenderInfo(factor, pos, hitx, hity, truetype, tileEntity.isBright());
                    module.render(matrixStack, buffer, (IModuleRenderHelper)this.clientScreenModuleHelper, fontrenderer, currenty, data, renderInfo);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                currenty += height;
            }
            ++moduleIndex;
        }
        if (mode != IClientScreenModule.TransformMode.NONE) {
            matrixStack.func_227865_b_();
        }
    }

    private void renderScreenBoard(MatrixStack matrixStack, IRenderTypeBuffer buffer, int size, int color, int packedLightIn, int packedOverlayIn) {
        float s;
        float dim;
        IVertexBuilder builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        if (size == 2) {
            dim = 2.46f;
            s = 2.0f;
        } else if (size == 1) {
            dim = 1.46f;
            s = 1.0f;
        } else {
            dim = 0.46f;
            s = 0.0f;
        }
        float fr = 0.5f;
        float fg = 0.5f;
        float fb = 0.5f;
        float zback = 0.05f;
        float zfront = -0.0f;
        builder.func_227888_a_(matrix, -0.5f, -0.5f, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, -0.5f, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, 0.5f + s, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.5f + s, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.5f + s, zfront).func_227885_a_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, 0.5f + s, zfront).func_227885_a_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, -0.5f, zfront).func_227885_a_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, -0.5f, zfront).func_227885_a_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.5f + s, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, 0.5f + s, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, 0.5f + s, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.5f + s, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, -0.5f, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, -0.5f, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, -0.5f, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, -0.5f, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, -0.5f, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, -0.5f, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.5f + s, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.5f + s, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, 0.5f + s, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, 0.5f + s, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, -0.5f, zback).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, 0.5f + s, -0.5f, zfront).func_227885_a_(fr, fg, fb, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.func_227888_a_(matrix, -0.46f, dim, -0.01f).func_227885_a_(r, g, b, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, dim, dim, -0.01f).func_227885_a_(r, g, b, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, dim, -0.46f, -0.01f).func_227885_a_(r, g, b, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, -0.46f, -0.46f, -0.01f).func_227885_a_(r, g, b, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        matrixStack.func_227865_b_();
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ScreenSetup.TYPE_SCREEN.get()), ScreenRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ScreenSetup.TYPE_CREATIVE_SCREEN.get()), ScreenRenderer::new);
    }
}

