/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenModuleGuiBuilder;
import mcjty.rftoolsutility.modules.screen.network.PacketModuleUpdate;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GuiScreen
extends GenericGuiContainer<ScreenTileEntity, GenericContainer> {
    public static final int SCREEN_WIDTH = 256;
    public static final int SCREEN_HEIGHT = 224;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsutility", "textures/gui/screen.png");
    private Panel toplevel;
    private ToggleButton[] buttons = new ToggleButton[11];
    private Panel[] modulePanels = new Panel[11];
    private IClientScreenModule<?>[] clientScreenModules = new IClientScreenModule[11];
    private ToggleButton bright;
    private ChoiceLabel trueType;
    private int selected = -1;

    public GuiScreen(ScreenTileEntity screenTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsUtility.instance, (GenericTileEntity)screenTileEntity, (Container)container, inventory, 0, "screens");
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void init() {
        super.init();
        this.toplevel = ((Panel)new Panel(this.minecraft, (Screen)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        for (int i = 0; i < 11; ++i) {
            this.buttons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.minecraft, (Screen)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 7 + i * 18 + 1, 40, 16))).setEnabled(false)).setTooltips(new String[]{"Open the gui for this", "module"});
            int finalI = i;
            this.buttons[i].addButtonEvent(parent -> this.selectPanel(finalI));
            this.toplevel.addChild((Widget)this.buttons[i]);
            this.modulePanels[i] = null;
            this.clientScreenModules[i] = null;
        }
        this.bright = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.minecraft, (Screen)this).setName("bright")).setText("Bright")).setCheckMarker(true).setTooltips(new String[]{"Toggle full brightness"})).setLayoutHint(85, 123, 55, 14);
        this.toplevel.addChild((Widget)this.bright);
        this.toplevel.addChild((Widget)((Label)((Label)new Label(this.minecraft, (Screen)this).setText("Font:")).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(144, 123, 30, 14)));
        this.trueType = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.minecraft, (Screen)this).addChoices(new String[]{"Default", "Truetype", "Vanilla"}).setTooltips(new String[]{"Set truetype font mode", "for the screen"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(179, 123, 68, 14));
        int trueTypeMode = ((ScreenTileEntity)this.tileEntity).getTrueTypeMode();
        this.trueType.setChoice(trueTypeMode == 0 ? "Default" : (trueTypeMode == -1 ? "Vanilla" : "Truetype"));
        this.trueType.addChoiceEvent((a, b) -> this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "screen.setTruetype", TypedMap.builder().put(ScreenTileEntity.PARAM_TRUETYPE, (Object)this.getCurrentTruetypeChoice()).build()));
        this.toplevel.addChild((Widget)this.trueType);
        this.toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((Screen)this, (AbstractContainerWidget)this.toplevel);
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "bright", this.tileEntity, ScreenTileEntity.VALUE_BRIGHT.getName());
        this.minecraft.field_195559_v.func_197967_a(true);
        this.selected = -1;
    }

    private int getCurrentTruetypeChoice() {
        String c = this.trueType.getCurrentChoice();
        if ("Default".equals(c)) {
            return 0;
        }
        if ("Truetype".equals(c)) {
            return 1;
        }
        return -1;
    }

    private void selectPanel(int i) {
        this.selected = this.buttons[i].isPressed() ? i : -1;
    }

    private void refreshButtons() {
        ((ScreenTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < 11; ++i) {
                ItemStack slot = h.getStackInSlot(i);
                if (!slot.func_190926_b() && ScreenBlock.hasModuleProvider(slot)) {
                    int finalI = i;
                    ScreenBlock.getModuleProvider(slot).ifPresent(moduleProvider -> {
                        Class clientScreenModuleClass = moduleProvider.getClientScreenModule();
                        if (!clientScreenModuleClass.isInstance(this.clientScreenModules[finalI])) {
                            this.installModuleGui(finalI, slot, (IModuleProvider)moduleProvider, clientScreenModuleClass);
                        }
                    });
                } else {
                    this.uninstallModuleGui(i);
                }
                if (this.modulePanels[i] == null) continue;
                this.modulePanels[i].setVisible(this.selected == i);
                this.buttons[i].setPressed(this.selected == i);
            }
        });
    }

    private void uninstallModuleGui(int i) {
        this.buttons[i].setEnabled(false);
        this.buttons[i].setPressed(false);
        this.buttons[i].setText("");
        this.clientScreenModules[i] = null;
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        this.modulePanels[i] = null;
        if (this.selected == i) {
            this.selected = -1;
        }
    }

    private void installModuleGui(int i, ItemStack slot, IModuleProvider moduleProvider, Class<? extends IClientScreenModule<?>> clientScreenModuleClass) {
        this.buttons[i].setEnabled(true);
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        try {
            IClientScreenModule<?> clientScreenModule = clientScreenModuleClass.newInstance();
            this.clientScreenModules[i] = clientScreenModule;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        CompoundNBT tagCompound = slot.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        CompoundNBT finalTagCompound = tagCompound;
        ScreenModuleGuiBuilder guiBuilder = new ScreenModuleGuiBuilder(this.minecraft, (Screen)this, tagCompound, () -> {
            slot.func_77982_d(finalTagCompound);
            ((ScreenTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> ((IItemHandlerModifiable)h).setStackInSlot(i, slot));
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketModuleUpdate(((ScreenTileEntity)this.tileEntity).func_174877_v(), i, finalTagCompound));
        });
        moduleProvider.createGui((IModuleGuiBuilder)guiBuilder);
        this.modulePanels[i] = guiBuilder.build();
        this.modulePanels[i].setLayoutHint(80, 8, 170, 114);
        ((Panel)this.modulePanels[i].setFilledRectThickness(-2)).setFilledBackground(-7631989);
        this.toplevel.addChild((Widget)this.modulePanels[i]);
        this.buttons[i].setText(moduleProvider.getModuleName());
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.refreshButtons();
        this.drawWindow();
    }
}

