/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsutility.modules.screen.ScreenSetup;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitTileEntity;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.client.ScreenRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class ScreenBlock
extends BaseBlock {
    public static final DirectionProperty HORIZ_FACING = DirectionProperty.func_177712_a((String)"horizfacing", (Predicate)Direction.Plane.HORIZONTAL);
    private final boolean creative;
    private static long lastTime = 0L;
    private static Setup[] transitions = new Setup[]{new Setup(0, false), new Setup(0, true), new Setup(1, false), new Setup(1, true), new Setup(2, false), new Setup(2, true)};
    public static final VoxelShape BLOCK_AABB = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape NORTH_AABB = VoxelShapes.func_197873_a((double)0.01f, (double)0.01f, (double)0.9375, (double)0.99f, (double)0.99f, (double)1.0);
    public static final VoxelShape SOUTH_AABB = VoxelShapes.func_197873_a((double)0.01f, (double)0.01f, (double)0.0, (double)0.99f, (double)0.99f, (double)0.0625);
    public static final VoxelShape WEST_AABB = VoxelShapes.func_197873_a((double)0.9375, (double)0.01f, (double)0.01f, (double)1.0, (double)0.99f, (double)0.99f);
    public static final VoxelShape EAST_AABB = VoxelShapes.func_197873_a((double)0.0, (double)0.01f, (double)0.01f, (double)0.0625, (double)0.99f, (double)0.99f);
    public static final VoxelShape UP_AABB = VoxelShapes.func_197873_a((double)0.01f, (double)0.0, (double)0.01f, (double)1.0, (double)0.061875f, (double)0.99f);
    public static final VoxelShape DOWN_AABB = VoxelShapes.func_197873_a((double)0.01f, (double)0.9375, (double)0.01f, (double)0.99f, (double)1.0, (double)0.99f);

    public ScreenBlock(Supplier<TileEntity> supplier, boolean creative) {
        super(new BlockBuilder().tileEntitySupplier(supplier));
        this.creative = creative;
    }

    public boolean isCreative() {
        return this.creative;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)HORIZ_FACING, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d());
    }

    public void initModel() {
        ScreenRenderer.register();
    }

    public static boolean hasModuleProvider(ItemStack stack) {
        return stack.func_77973_b() instanceof IModuleProvider || stack.getCapability(IModuleProvider.CAPABILITY).isPresent();
    }

    public static LazyOptional<IModuleProvider> getModuleProvider(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IModuleProvider) {
            return LazyOptional.of(() -> (IModuleProvider)item);
        }
        return stack.getCapability(IModuleProvider.CAPABILITY);
    }

    public ActionResultType activate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return this.func_225533_a_(state, world, pos, player, hand, result);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        return state;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            RayTraceResult mouseOver = McJtyLib.proxy.getClientMouseOver();
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
            if (mouseOver instanceof BlockRayTraceResult) {
                screenTileEntity.hitScreenClient(mouseOver.func_216347_e().field_72450_a - (double)pos.func_177958_n(), mouseOver.func_216347_e().field_72448_b - (double)pos.func_177956_o(), mouseOver.func_216347_e().field_72449_c - (double)pos.func_177952_p(), ((BlockRayTraceResult)mouseOver).func_216354_b(), (Direction)world.func_180495_p(pos).func_177229_b((IProperty)HORIZ_FACING));
            }
        }
    }

    private void setInvisibleBlockSafe(World world, BlockPos pos, int dx, int dy, int dz, Direction facing) {
        int zz;
        int yy = pos.func_177956_o() + dy;
        if (yy < 0 || yy >= world.func_217301_I()) {
            return;
        }
        int xx = pos.func_177958_n() + dx;
        BlockPos posO = new BlockPos(xx, yy, zz = pos.func_177952_p() + dz);
        if (world.func_175623_d(posO)) {
            world.func_180501_a(posO, (BlockState)((ScreenHitBlock)ScreenSetup.SCREEN_HIT.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing), 3);
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(posO);
            screenHitTileEntity.setRelativeLocation(-dx, -dy, -dz);
        }
    }

    private void setInvisibleBlocks(World world, BlockPos pos, int size) {
        BlockState state = world.func_180495_p(pos);
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        Direction horizontalFacing = (Direction)state.func_177229_b((IProperty)HORIZ_FACING);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == Direction.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, -j, 0, facing);
                    continue;
                }
                if (facing == Direction.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, -j, 0, facing);
                    continue;
                }
                if (facing == Direction.WEST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, j, facing);
                    continue;
                }
                if (facing == Direction.EAST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, -j, facing);
                    continue;
                }
                if (facing == Direction.UP) {
                    if (horizontalFacing == Direction.NORTH) {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
                        continue;
                    }
                    if (horizontalFacing == Direction.SOUTH) {
                        this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                        continue;
                    }
                    if (horizontalFacing == Direction.WEST) {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                        continue;
                    }
                    if (horizontalFacing != Direction.EAST) continue;
                    this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                    continue;
                }
                if (facing != Direction.DOWN) continue;
                if (horizontalFacing == Direction.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                    continue;
                }
                if (horizontalFacing == Direction.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                    continue;
                }
                if (horizontalFacing == Direction.WEST) {
                    this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                    continue;
                }
                if (horizontalFacing != Direction.EAST) continue;
                this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
            }
        }
    }

    private void clearInvisibleBlockSafe(World world, BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_217301_I()) {
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() == ScreenSetup.SCREEN_HIT.get()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void clearInvisibleBlocks(World world, BlockPos pos, BlockState state, int size) {
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        Direction horizontalFacing = (Direction)state.func_177229_b((IProperty)HORIZ_FACING);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == Direction.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, -j, 0));
                    continue;
                }
                if (facing == Direction.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, -j, 0));
                    continue;
                }
                if (facing == Direction.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(0, -i, j));
                    continue;
                }
                if (facing == Direction.EAST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(0, -i, -j));
                    continue;
                }
                if (facing == Direction.UP) {
                    if (horizontalFacing == Direction.NORTH) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, -j));
                        continue;
                    }
                    if (horizontalFacing == Direction.SOUTH) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, j));
                        continue;
                    }
                    if (horizontalFacing == Direction.WEST) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, j));
                        continue;
                    }
                    if (horizontalFacing != Direction.EAST) continue;
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, -j));
                    continue;
                }
                if (facing != Direction.DOWN) continue;
                if (horizontalFacing == Direction.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, j));
                    continue;
                }
                if (horizontalFacing == Direction.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, -j));
                    continue;
                }
                if (horizontalFacing == Direction.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, j));
                    continue;
                }
                if (horizontalFacing != Direction.EAST) continue;
                this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, -j));
            }
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        this.cycleSizeTranspMode(world, pos);
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{HORIZ_FACING});
    }

    public void cycleSizeTranspMode(World world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[(i + 1) % transitions.length];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    public void cycleSizeMode(World world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[(i + 2) % transitions.length];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    public void cycleTranspMode(World world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[i % 2 == 0 ? i + 1 : i - 1];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    protected boolean openGui(World world, int x, int y, int z, PlayerEntity player) {
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_222086_lz) {
            int damage = itemStack.func_77952_i();
            if (damage < 0) {
                damage = 0;
            } else if (damage > 15) {
                damage = 15;
            }
            DyeColor color = DyeColor.func_196056_a((int)damage);
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(new BlockPos(x, y, z));
            screenTileEntity.setColor(color.func_196055_e().field_76291_p);
            return true;
        }
        if (player.func_225608_bj_()) {
            return super.openGui(world, x, y, z, player);
        }
        if (world.field_72995_K) {
            this.activateOnClient(world, new BlockPos(x, y, z));
        }
        return true;
    }

    private void activateOnClient(World world, BlockPos pos) {
        RayTraceResult mouseOver = McJtyLib.proxy.getClientMouseOver();
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        if (mouseOver instanceof BlockRayTraceResult) {
            screenTileEntity.hitScreenClient(mouseOver.func_216347_e().field_72450_a - (double)pos.func_177958_n(), mouseOver.func_216347_e().field_72448_b - (double)pos.func_177956_o(), mouseOver.func_216347_e().field_72449_c - (double)pos.func_177952_p(), ((BlockRayTraceResult)mouseOver).func_216354_b(), (Direction)world.func_180495_p(pos).func_177229_b((IProperty)HORIZ_FACING));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        if (facing == Direction.NORTH) {
            return NORTH_AABB;
        }
        if (facing == Direction.SOUTH) {
            return SOUTH_AABB;
        }
        if (facing == Direction.WEST) {
            return WEST_AABB;
        }
        if (facing == Direction.EAST) {
            return EAST_AABB;
        }
        if (facing == Direction.UP) {
            return UP_AABB;
        }
        if (facing == Direction.DOWN) {
            return DOWN_AABB;
        }
        return BLOCK_AABB;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_190948_a(ItemStack itemStack, IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(itemStack, world, list, flag);
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int size = tagCompound.func_74764_b("large") ? (tagCompound.func_74767_n("large") ? 1 : 0) : tagCompound.func_74762_e("size");
            boolean transparent = tagCompound.func_74767_n("transparent");
            if (size == 2) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Huge screen."));
            } else if (size == 1) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Large screen."));
            }
            if (transparent) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Transparent screen."));
            }
            int rc = 0;
            ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < bufferTagList.size(); ++i) {
                ItemStack stack;
                CompoundNBT tag = bufferTagList.func_150305_b(i);
                if (tag == null || (stack = ItemStack.func_199557_a((CompoundNBT)tag)).func_190926_b()) continue;
                ++rc;
            }
            list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + String.valueOf(rc) + " modules"));
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This is a modular screen. As such it doesn't show anything."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "You must insert modules to control what you can see."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This screen cannot be directly powered. It has to be remotely"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "powered by a nearby Screen Controller."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entityLivingBase, ItemStack itemStack) {
        ScreenTileEntity screenTileEntity;
        TileEntity tileEntity;
        super.func_180633_a(world, pos, state, entityLivingBase, itemStack);
        if (entityLivingBase instanceof PlayerEntity) {
            // empty if block
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof ScreenTileEntity && (screenTileEntity = (ScreenTileEntity)tileEntity).getSize() > 0) {
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        ScreenTileEntity screenTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ScreenTileEntity && (screenTileEntity = (ScreenTileEntity)te).getSize() > 0) {
            this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        }
        super.func_196243_a(state, world, pos, newstate, isMoving);
    }

    private static class Setup {
        private final boolean transparent;
        private final int size;

        public Setup(int size, boolean transparent) {
            this.size = size;
            this.transparent = transparent;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isTransparent() {
            return this.transparent;
        }
    }
}

