/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen;

import java.util.HashMap;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsutility.modules.screen.MachineInfo;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnRfInRange;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkDirection;

public class RFToolsTools {
    public static boolean hasModuleTarget(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("monitorx");
    }

    public static void setPositionInModule(ItemStack stack, DimensionType dimension, BlockPos pos, String name) {
        CompoundNBT tag = stack.func_196082_o();
        if (dimension != null) {
            tag.func_74778_a("monitordim", dimension.getRegistryName().toString());
        }
        if (name != null) {
            tag.func_74778_a("monitorname", name);
        }
        tag.func_74768_a("monitorx", pos.func_177958_n());
        tag.func_74768_a("monitory", pos.func_177956_o());
        tag.func_74768_a("monitorz", pos.func_177952_p());
    }

    public static void clearPositionInModule(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_82580_o("monitordim");
        tag.func_82580_o("monitorx");
        tag.func_82580_o("monitory");
        tag.func_82580_o("monitorz");
        tag.func_82580_o("monitorname");
    }

    public static BlockPos getPositionFromModule(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        int monitorx = tag.func_74762_e("monitorx");
        int monitory = tag.func_74762_e("monitory");
        int monitorz = tag.func_74762_e("monitorz");
        return new BlockPos(monitorx, monitory, monitorz);
    }

    public static void returnRfInRange(PlayerEntity player) {
        BlockPos pos = player.func_180425_c();
        World world = player.func_130014_f_();
        HashMap<BlockPos, MachineInfo> result = new HashMap<BlockPos, MachineInfo>();
        int range = 12;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos p = pos.func_177982_a(x, y, z);
                    TileEntity te = world.func_175625_s(p);
                    if (!EnergyTools.isEnergyTE((TileEntity)te, null)) continue;
                    EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevel((TileEntity)te, null);
                    Long usage = (Long)te.getCapability(CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY).map(h -> h.getEnergyDiffPerTick()).orElse((Object)0L);
                    result.put(p, new MachineInfo(level.getEnergy(), level.getMaxEnergy(), usage));
                }
            }
        }
        RFToolsUtilityMessages.INSTANCE.sendTo((Object)new PacketReturnRfInRange(result), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }
}

