/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.mover;

import com.yogpc.qp.machines.item.ContainerEnchList;
import com.yogpc.qp.machines.item.GuiEnchList;
import com.yogpc.qp.machines.workbench.BlockData;
import com.yogpc.qp.packet.IMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class DiffMessage
implements IMessage<DiffMessage> {
    int containerId;
    List<BlockData> fortuneList;
    List<BlockData> silkList;

    @Override
    public DiffMessage readFromBuffer(PacketBuffer buffer) {
        int i;
        this.containerId = buffer.readInt();
        int fS = buffer.readInt();
        int sS = buffer.readInt();
        this.fortuneList = new ArrayList<BlockData>(fS);
        this.silkList = new ArrayList<BlockData>(sS);
        for (i = 0; i < fS; ++i) {
            this.fortuneList.add(BlockData.read(buffer.func_150793_b()));
        }
        for (i = 0; i < sS; ++i) {
            this.silkList.add(BlockData.read(buffer.func_150793_b()));
        }
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeInt(this.containerId);
        buffer.writeInt(this.fortuneList.size()).writeInt(this.silkList.size());
        this.fortuneList.stream().map(arg_0 -> BlockData.dataToNbt().apply(arg_0)).forEach(arg_0 -> ((PacketBuffer)buffer).func_150786_a(arg_0));
        this.silkList.stream().map(arg_0 -> BlockData.dataToNbt().apply(arg_0)).forEach(arg_0 -> ((PacketBuffer)buffer).func_150786_a(arg_0));
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiEnchList) {
                ContainerEnchList enchList = (ContainerEnchList)((GuiEnchList)screen).func_212873_a_();
                enchList.tile.fortuneList.clear();
                enchList.tile.fortuneList.addAll((Collection<BlockData>)this.fortuneList);
                enchList.tile.silktouchList.clear();
                enchList.tile.silktouchList.addAll((Collection<BlockData>)this.silkList);
                ((GuiEnchList)screen).refreshList();
            }
        });
    }

    public static DiffMessage create(Container container, List<BlockData> fortuneList, List<BlockData> silkList) {
        DiffMessage message = new DiffMessage();
        message.containerId = container.field_75152_c;
        message.fortuneList = fortuneList;
        message.silkList = silkList;
        return message;
    }
}

