/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.Config;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.EnchantmentHolder;
import com.yogpc.qp.machines.base.EnergyUsage;
import com.yogpc.qp.machines.quarry.TileMiningWell;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeConfigSpec;

public class PowerManager {
    private static double QuarryWork_CF;
    private static double QuarryWork_CS;
    private static double MiningWell_CF;
    private static double MiningWell_CS;
    private static long QuarryWork_BP;
    private static double QuarryWork_CE;
    private static double QuarryWork_CU;
    private static long QuarryWork_XR;
    private static long QuarryWork_MS;
    private static long FrameBuild_BP;
    private static double FrameBuild_CE;
    private static double FrameBuild_CU;
    private static long FrameBuild_XR;
    private static long FrameBuild_MS;
    private static long MiningWell_BP;
    private static double MiningWell_CE;
    private static double MiningWell_CU;
    private static long MiningWell_XR;
    private static long MiningWell_MS;
    private static long Laser_BP;
    private static double Laser_CE;
    private static double Laser_CU;
    private static long Laser_XR;
    private static long Laser_MS;
    private static double Laser_CF;
    private static double Laser_CS;
    private static double Refinery_CE;
    private static double Refinery_CU;
    private static long Refinery_XR;
    private static long Refinery_MS;
    private static long PumpFrame_BP;
    private static double PumpFrame_CU;
    private static long PumpDrain_BP;
    private static double PumpDrain_CU;
    private static long MoveHead_BP;
    private static double MoveHead_CU;

    public static void configRegister() {
        long micro = 1000000L;
        String cat = "Quarry.BreakBlock.";
        QuarryWork_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        QuarryWork_XR = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxReceive"))).get() * (double)micro);
        QuarryWork_MS = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxStored"))).get() * (double)micro);
        QuarryWork_CE = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "EfficiencyCoefficient"))).get();
        QuarryWork_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        QuarryWork_CF = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "FortuneCoefficient"))).get();
        QuarryWork_CS = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "SilktouchCoefficient"))).get();
        cat = "Quarry.MakeFrame.";
        FrameBuild_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        FrameBuild_XR = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxReceive"))).get() * (double)micro);
        FrameBuild_MS = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxStored"))).get() * (double)micro);
        FrameBuild_CE = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "EfficiencyCoefficient"))).get();
        FrameBuild_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        cat = "Quarry.BreakBlock.MoveHead.";
        MoveHead_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        MoveHead_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        cat = "Pump.DrainLiquid.";
        PumpDrain_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        PumpDrain_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        cat = "Pump.MakeFrame.";
        PumpFrame_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        PumpFrame_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        cat = "MiningWell.";
        MiningWell_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        MiningWell_XR = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxReceive"))).get() * (double)micro);
        MiningWell_MS = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxStored"))).get() * (double)micro);
        MiningWell_CE = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "EfficiencyCoefficient"))).get();
        MiningWell_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        MiningWell_CF = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "FortuneCoefficient"))).get();
        MiningWell_CS = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "SilktouchCoefficient"))).get();
        cat = "Refinery.";
        Refinery_XR = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxReceive"))).get() * (double)micro);
        Refinery_MS = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxStored"))).get() * (double)micro);
        Refinery_CE = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "EfficiencyCoefficient"))).get();
        Refinery_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        cat = "Laser.";
        Laser_BP = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BasePower"))).get() * (double)micro);
        Laser_XR = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxReceive"))).get() * (double)micro);
        Laser_MS = (long)((Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "BaseMaxStored"))).get() * (double)micro);
        Laser_CE = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "EfficiencyCoefficient"))).get();
        Laser_CU = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "UnbreakingCoefficient"))).get();
        Laser_CF = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "FortuneCoefficient"))).get();
        Laser_CS = (Double)((ForgeConfigSpec.DoubleValue)Config.common().powers().apply((Object)(cat + "SilktouchCoefficient"))).get();
    }

    public static void configure0(APowerTile pp) {
        pp.configure(0L, pp.getMaxStored());
    }

    private static void configure(APowerTile pp, double CE, int efficiencyLevel, int unbreakingLevel, double CU, long maxReceive, long maxStored, int pump) {
        pp.configure((long)((double)maxReceive * Math.pow(CE, efficiencyLevel) / ((double)unbreakingLevel * CU + 1.0)), (long)((double)maxStored * Math.pow(CE, efficiencyLevel) / ((double)unbreakingLevel * CU + 1.0) + (pump > 0 ? (double)(65536L * PumpDrain_BP) / ((double)pump * PumpDrain_CU + 1.0) + (double)(1020L * PumpFrame_BP) / ((double)pump * PumpFrame_CU + 1.0) : 0.0)));
    }

    public static void configureQuarryWork(APowerTile pp, int efficiencyLevel, int unbreakingLevel, int pump) {
        PowerManager.configure(pp, QuarryWork_CE, efficiencyLevel, unbreakingLevel, QuarryWork_CU, QuarryWork_XR, QuarryWork_MS, pump);
    }

    public static void configureMiningWell(APowerTile pp, int efficiencyLevel, int unbreakingLevel, int pump) {
        PowerManager.configure(pp, MiningWell_CE, efficiencyLevel, unbreakingLevel, MiningWell_CU, MiningWell_XR, MiningWell_MS, pump);
    }

    public static void configureLaser(APowerTile pp, int efficiencyLevel, int unbreakingLevel) {
        PowerManager.configure(pp, Laser_CE, efficiencyLevel, unbreakingLevel, Laser_CU, Laser_XR, Laser_MS, 0);
    }

    public static void configureFrameBuild(APowerTile pp, int efficiencyLevel, int unbreakingLevel, int pump) {
        PowerManager.configure(pp, FrameBuild_CE, efficiencyLevel, unbreakingLevel, FrameBuild_CU, FrameBuild_XR, FrameBuild_MS, pump);
    }

    public static void configureRefinery(APowerTile pp, int efficiencyLevel, int unbreakingLevel) {
        PowerManager.configure(pp, Refinery_CE, efficiencyLevel, unbreakingLevel, Refinery_CU, Refinery_XR, Refinery_MS, 0);
    }

    public static boolean useEnergyBreak(APowerTile pp, float hardness, int enchantmentMode, int unbreaking, boolean replacer, boolean force) {
        if (enchantmentMode == -2) {
            return true;
        }
        long pw = (long)(PowerManager.calcEnergyBreak(pp, hardness, enchantmentMode, unbreaking) * (replacer ? 1.1 : 1.0));
        if (!force) {
            if (pp.useEnergy(pw, pw, false, EnergyUsage.BREAK_BLOCK) != pw) {
                return false;
            }
            pp.useEnergy(pw, pw, true, EnergyUsage.BREAK_BLOCK);
        } else {
            pp.useEnergyForce(pw, true, EnergyUsage.BREAK_BLOCK);
        }
        return true;
    }

    public static boolean useEnergyBreak(APowerTile pp, BlockPos pos, EnchantmentHolder enchantment, boolean replacer, boolean force) {
        if (pp.func_145831_w() != null) {
            float blockHardness = pp.func_145831_w().func_180495_p(pos).func_185887_b((IBlockReader)pp.func_145831_w(), pos);
            int mode = EnchantmentHolder.enchantmentMode(enchantment);
            return PowerManager.useEnergyBreak(pp, blockHardness, mode, enchantment.unbreaking(), replacer, force);
        }
        return true;
    }

    private static double calcEnergyBreak(APowerTile pp, float hardness, int enchantMode, int unbreaking) {
        double CSP;
        double CU;
        long BP;
        if (pp instanceof TileMiningWell) {
            BP = MiningWell_BP;
            CU = MiningWell_CU;
            CSP = enchantMode < 0 ? MiningWell_CS : Math.pow(MiningWell_CF, enchantMode);
        } else {
            BP = QuarryWork_BP;
            CU = QuarryWork_CU;
            CSP = enchantMode < 0 ? QuarryWork_CS : Math.pow(QuarryWork_CF, enchantMode);
        }
        return (double)((float)BP * hardness) * CSP / ((double)unbreaking * CU + 1.0);
    }

    public static long calcEnergyBreak(float hardness, int enchantMode, int unbreaking) {
        long BP = QuarryWork_BP;
        double CU = QuarryWork_CU;
        double CSP = enchantMode < 0 ? QuarryWork_CS : Math.pow(QuarryWork_CF, enchantMode);
        double fixedHardness = Math.pow(hardness, 1.1);
        return (long)((double)BP * fixedHardness * CSP / ((double)unbreaking * CU + 1.0));
    }

    public static long calcEnergyBreak(float hardness, EnchantmentHolder enchantmentHolder) {
        return PowerManager.calcEnergyBreak(hardness, EnchantmentHolder.enchantmentMode(enchantmentHolder), enchantmentHolder.unbreaking());
    }

    public static boolean useEnergyPump(APowerTile pp, int U, long liquidsCount, long framesToBuild) {
        long pw = PowerManager.calcEnergyPumpDrain(U, liquidsCount, framesToBuild);
        if (pp.useEnergy(pw, pw, false, EnergyUsage.PUMP_FLUID) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, EnergyUsage.PUMP_FLUID);
        return true;
    }

    public static long calcEnergyPumpDrain(int unbreaking, long liquids, long frames) {
        return (long)((double)(PumpDrain_BP * liquids) / ((double)unbreaking * PumpDrain_CU + 1.0) + (double)(PumpFrame_BP * frames) / ((double)unbreaking * PumpFrame_CU + 1.0));
    }

    private static boolean useEnergy(APowerTile pp, long BP, int U, double CU, int E, double CE, EnergyUsage usage) {
        long pw = (long)((double)BP / Math.pow(CE, E) / ((double)U * CU + 1.0));
        if (pp.useEnergy(pw, pw, false, usage) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, usage);
        return true;
    }

    public static boolean useEnergyFrameBuild(APowerTile pp, int U) {
        return PowerManager.useEnergy(pp, FrameBuild_BP, U, FrameBuild_CU, 0, 1.0, EnergyUsage.FRAME_BUILD);
    }

    public static boolean useEnergyRefinery(APowerTile pp, long BP, int U, int E) {
        return PowerManager.useEnergy(pp, BP, U, Refinery_CU, E, Refinery_CE, EnergyUsage.REFINERY);
    }

    public static double useEnergyQuarryHead(APowerTile pp, double dist, int U) {
        double bp = (double)MoveHead_BP / 1000000.0;
        double pw = (Boolean)Config.common().fastQuarryHeadMove().get() == false ? Math.min(2.0 + (double)pp.getStoredEnergy() / 500.0 / 1000000.0, (dist / 2.0 - 0.05) * bp / ((double)U * MoveHead_CU + 1.0)) : (dist / 2.0 - 0.05) * bp / ((double)U * MoveHead_CU + 1.0);
        pw = (double)pp.useEnergy(0L, (long)(pw * 1000000.0), true, EnergyUsage.MOVE_HEAD) / 1000000.0;
        return pw * ((double)U * MoveHead_CU + 1.0) / bp + 0.05;
    }

    public static long calcEnergyQuarryHead(APowerTile pp, double dist, int U) {
        long bp = MoveHead_BP;
        long pw = (Boolean)Config.common().fastQuarryHeadMove().get() == false ? Math.min(2L + pp.getStoredEnergy() / 500L, (long)((dist / 2.0 - 0.05) * (double)bp / ((double)U * MoveHead_CU + 1.0))) : (long)((dist / 2.0 - 0.05) * (double)bp / ((double)U * MoveHead_CU + 1.0));
        return pw;
    }

    public static long simulateEnergyLaser(APowerTile pp, int U, int F, boolean S, int E) {
        long pw = (long)((double)Laser_BP * Math.pow(Laser_CF, F) * Math.pow(Laser_CE, E) / ((double)U * Laser_CU + 1.0));
        if (S) {
            long used = pp.useEnergy(0L, (long)((double)pw * Laser_CS), false, EnergyUsage.LASER);
            return (long)((double)used / Laser_CS * ((double)U * Laser_CU + 1.0) / Math.pow(Laser_CF, F));
        }
        long used = pp.useEnergy(0L, pw, false, EnergyUsage.LASER);
        return (long)((double)used * ((double)U * Laser_CU + 1.0) / Math.pow(Laser_CF, F));
    }

    public static void useEnergyLaser(APowerTile pp, long power, int U, int F, boolean S, boolean simulate) {
        long pw = (long)((double)power * Math.pow(Laser_CF, F) * (S ? Laser_CS : 1.0) / ((double)U * Laser_CU + 1.0));
        pp.useEnergy(pw, pw, !simulate, EnergyUsage.LASER);
    }

    public static long calcEnergyAdvSearch(int unbreakingLevel, int targetY) {
        return (long)((double)(MoveHead_BP * (long)targetY) / (MoveHead_CU * (double)unbreakingLevel + 1.0) / 4.0);
    }
}

