/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class WidgetColorDisplay
extends Widget {
    private Color colorA;
    private Color colorB;
    private boolean horizontal;

    public WidgetColorDisplay(Color color) {
        this.colorA = color;
        this.colorB = color;
        this.horizontal = false;
    }

    public WidgetColorDisplay(Color primary, Color secondary, boolean horizontal) {
        this.colorA = primary;
        this.colorB = secondary;
        this.horizontal = horizontal;
    }

    public Color getColor() {
        return this.colorA;
    }

    public Color getSecondaryColor() {
        return this.colorB;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public WidgetColorDisplay setColor(Color color) {
        this.colorA = color;
        return this;
    }

    public WidgetColorDisplay setSecondaryColor(Color color) {
        this.colorB = color;
        return this;
    }

    public WidgetColorDisplay setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    @Override
    public void draw(Screen screen) {
        if (this.isHorizontal()) {
            WidgetColorDisplay.drawHorizontalGradientRect(0, 0, this.width, this.height, this.colorA, this.colorB);
        } else {
            WidgetColorDisplay.drawVerticalGradientRect(0, 0, this.width, this.height, this.colorA, this.colorB);
        }
    }

    private static void drawHorizontalGradientRect(int x1, int y1, int x2, int y2, Color primary, Color secondary) {
        float zLevel = 0.0f;
        float[] pColors = primary.getRGBColorComponents(null);
        float pA = 1.0f;
        float pR = pColors[0];
        float pG = pColors[1];
        float pB = pColors[2];
        float[] sColors = secondary.getRGBColorComponents(null);
        float sA = 1.0f;
        float sR = sColors[0];
        float sG = sColors[1];
        float sB = sColors[2];
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x1, (double)y1, (double)zLevel).func_227885_a_(pR, pG, pB, pA).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y2, (double)zLevel).func_227885_a_(pR, pG, pB, pA).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)zLevel).func_227885_a_(sR, sG, sB, sA).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)zLevel).func_227885_a_(sR, sG, sB, sA).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    private static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, Color primary, Color secondary) {
        float zLevel = 0.0f;
        float[] pColors = primary.getRGBColorComponents(null);
        float pA = 1.0f;
        float pR = pColors[0];
        float pG = pColors[1];
        float pB = pColors[2];
        float[] sColors = secondary.getRGBColorComponents(null);
        float sA = 1.0f;
        float sR = sColors[0];
        float sG = sColors[1];
        float sB = sColors[2];
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)x2, (double)y1, (double)zLevel).func_227885_a_(pR, pG, pB, pA).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)zLevel).func_227885_a_(pR, pG, pB, pA).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y2, (double)zLevel).func_227885_a_(sR, sG, sB, sA).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)zLevel).func_227885_a_(sR, sG, sB, sA).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

