/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.config.types;

import com.davenonymous.libnonymous.gui.config.types.SettingListEntry;
import com.davenonymous.libnonymous.gui.framework.ColorHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetInputField;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.libnonymous.utils.Logz;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;

public class ListSettingListEntry
extends SettingListEntry {
    WidgetInputField inputField;

    public ListSettingListEntry(String optionKey, String comment, ForgeConfigSpec.ConfigValue value, Object defaultValue, int columnWidth) {
        super(optionKey, comment, value, defaultValue, columnWidth);
    }

    @Override
    public void fillPanel(int entryHeight) {
        if (this.defaultValue == null || !(this.defaultValue instanceof List) || ((List)this.defaultValue).size() == 0) {
            this.addUnsupportedRow(entryHeight);
            Logz.warn("Config lists without default value are not supported. We don't know the type otherwise!", new Object[0]);
            return;
        }
        this.setSize(this.columnWidth, entryHeight + 28);
        WidgetTextBox textBox = new WidgetTextBox(I18n.func_135052_a((String)"libnonymous.config.gui.label.separate_with_commas", (Object[])new Object[0]), -1597190964);
        textBox.setSize(this.columnWidth - 10, 9);
        textBox.setPosition(2, entryHeight - 4);
        this.add(textBox);
        Object firstDefaultValue = ((List)this.defaultValue).get(0);
        if (firstDefaultValue instanceof String) {
            List val = (List)this.value.get();
            this.inputField = new WidgetInputField();
            this.inputField.setValue(this.buildStringFromValue(val));
            this.inputField.setDimensions(3, 35, this.columnWidth - 26, 14);
            this.add(this.inputField);
            WidgetFontAwesome save = new WidgetFontAwesome(SAVE_ICON, WidgetFontAwesome.IconSize.MEDIUM);
            save.setColor(ColorHelper.COLOR_DISABLED);
            save.setPosition(this.columnWidth - 16, 34);
            save.addListener(MouseEnterEvent.class, (event, widget) -> {
                save.setColor(ColorHelper.COLOR_ENABLED);
                return WidgetEventResult.CONTINUE_PROCESSING;
            });
            save.addListener(MouseExitEvent.class, (event, widget) -> {
                save.setColor(ColorHelper.COLOR_DISABLED);
                return WidgetEventResult.CONTINUE_PROCESSING;
            });
            save.addListener(MouseClickEvent.class, (event, widget) -> {
                String inputText = this.inputField.getText();
                if (inputText == null || inputText.length() == 0) {
                    this.value.set((Object)Collections.EMPTY_LIST);
                } else {
                    this.value.set(Arrays.asList(inputText.split(",")));
                }
                this.value.save();
                this.updateDefaultIconState();
                return WidgetEventResult.CONTINUE_PROCESSING;
            });
            this.add(save);
        }
    }

    private String buildStringFromValue(List<String> val) {
        StringBuilder sb = new StringBuilder();
        for (String listEntry : val) {
            sb.append(listEntry);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public void setValueInInputField(Object defaultValue) {
        if (this.inputField != null) {
            if (defaultValue == null) {
                this.inputField.setValue("");
            } else {
                this.inputField.setValue(this.buildStringFromValue((List)defaultValue));
            }
        }
    }
}

