/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import owmii.lib.block.TileBase;
import owmii.lib.client.screen.TileContainerScreen;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.client.util.Draw;
import owmii.lib.energy.Energy;
import owmii.lib.energy.SideConfig;
import owmii.lib.inventory.EnergyContainerBase;
import owmii.lib.inventory.slot.SlotBase;
import owmii.lib.network.packets.SNextEnergyConfigPacket;
import owmii.lib.network.packets.SNextRedstoneModePacket;

@OnlyIn(value=Dist.CLIENT)
public class EnergyScreen<T extends TileBase.EnergyStorage, C extends EnergyContainerBase<T>>
extends TileContainerScreen<T, C> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lollipop", "textures/gui/container/energy.png");
    private static final ResourceLocation GUI_MACHINE = new ResourceLocation("lollipop", "textures/gui/container/energy_blank.png");
    private static final ResourceLocation GUI_WIDGET = new ResourceLocation("lollipop", "textures/gui/container/widget.png");
    public static final ResourceLocation GUI_BUFFER = new ResourceLocation("lollipop", "textures/gui/container/buffer.png");
    protected IconButton[] configButtons = new IconButton[6];
    protected IconButton configButtonAll = ICON_BUTTON;
    protected IconButton showConfigButton = ICON_BUTTON;
    protected IconButton redStoneButton = ICON_BUTTON;
    protected boolean configVisible;

    public EnergyScreen(C container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.field_146999_f = 195;
        this.field_147000_g = 164;
    }

    @Override
    protected void init() {
        super.init();
        boolean b = this.showConfigButton();
        this.mainButtons(this.x, this.y + (b ? 0 : -14));
        this.configButtons(this.x, this.y);
        this.showConfigButton.visible = b;
    }

    protected boolean showConfigButton() {
        return true;
    }

    protected void mainButtons(int x, int y) {
        this.showConfigButton = this.addIconButton(x + this.field_146999_f - 18, y + 13, 15, 15, 15, 0, 15, this.getWidgetTexture(), button -> {
            this.configVisible = !this.configVisible;
        }).tooltip("info.lollipop.configuration", TextFormatting.GRAY, new Object[0]);
        this.redStoneButton = this.addIconButton(x + this.field_146999_f - 18, y + 29, 15, 15, 30, 0, 15, this.getWidgetTexture(), button -> {
            SNextRedstoneModePacket.send(((TileBase.EnergyStorage)this.te).func_174877_v());
            ((TileBase.EnergyStorage)this.te).nextRedstoneMode();
        }).tooltip(((TileBase.EnergyStorage)this.te).getRedstoneMode().getDisplayName(), new Object[0]);
    }

    protected void configButtons(int x, int y) {
        this.configButtonAll = this.addIconButton(x + 151, y + 11, 15, 15, 30, 0, 15, this.getWidgetTexture(), button -> {
            SNextEnergyConfigPacket.send(6, ((TileBase.EnergyStorage)this.te).func_174877_v());
            ((TileBase.EnergyStorage)this.te).getSideConfig().nextTypeAllSides();
        }).tooltip("info.lollipop.side.all", TextFormatting.GRAY, new Object[]{TextFormatting.DARK_GRAY}).tooltip(((TileBase.EnergyStorage)this.te).getSideConfig().getType(Direction.UP).getDisplayName(), new Object[0]);
        for (int i = 0; i < 6; ++i) {
            int xOffset = (Integer)this.getSideButtonOffsets(18).get(i).getLeft();
            int yOffset = (Integer)this.getSideButtonOffsets(18).get(i).getRight();
            Direction side = Direction.func_82600_a((int)i);
            this.configButtons[i] = this.addIconButton(x + 132 + xOffset, y + 28 + yOffset, 17, 17, 0, 30, 17, this.getWidgetTexture(), button -> {
                SNextEnergyConfigPacket.send(side.func_176745_a(), ((TileBase.EnergyStorage)this.te).func_174877_v());
                ((TileBase.EnergyStorage)this.te).getSideConfig().nextType(side);
            }).tooltip("info.lollipop.side." + side.func_176610_l(), TextFormatting.GRAY, new Object[]{TextFormatting.DARK_GRAY}).tooltip(((TileBase.EnergyStorage)this.te).getSideConfig().getType(side).getDisplayName(), new Object[0]);
        }
    }

    private List<Pair<Integer, Integer>> getSideButtonOffsets(int spacing) {
        ArrayList pairs = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)0, (Object)spacing), Pair.of((Object)0, (Object)(-spacing)), Pair.of((Object)0, (Object)0), Pair.of((Object)spacing, (Object)spacing), Pair.of((Object)(-spacing), (Object)0), Pair.of((Object)spacing, (Object)0)});
        return pairs;
    }

    @Override
    protected void refreshScreen() {
        this.configButtonAll.visible = this.configVisible;
        SideConfig config = ((TileBase.EnergyStorage)this.te).getSideConfig();
        for (int i = 0; i < this.configButtons.length; ++i) {
            this.configButtons[i].visible = this.configVisible;
            this.configButtons[i].setIconDiff(((TileBase.EnergyStorage)this.te).getSideConfig().getType(Direction.func_82600_a((int)i)).getXuv());
            if (!this.configVisible || !this.configButtons[i].isHovered()) continue;
            List<String> list = this.configButtons[i].getTooltip();
            list.add(config.getType(Direction.func_82600_a((int)i)).getDisplayName());
            list.remove(1);
        }
        this.redStoneButton.setIconDiff(((TileBase.EnergyStorage)this.te).getRedstoneMode().getXuv());
        if (this.redStoneButton.isHovered()) {
            List<String> list = this.redStoneButton.getTooltip();
            list.add(((TileBase.EnergyStorage)this.te).getRedstoneMode().getDisplayName());
            list.remove(0);
        }
        if (this.configVisible && this.configButtonAll.isHovered()) {
            List<String> list = this.configButtonAll.getTooltip();
            if (!config.isAllSame()) {
                if (list.size() == 2) {
                    list.remove(1);
                }
            } else {
                String s = config.getType(Direction.func_82600_a((int)0)).getDisplayName();
                if (list.size() == 1) {
                    list.add(s);
                } else {
                    list.add(s);
                    list.remove(1);
                }
            }
        }
    }

    @Override
    protected void drawForeground(int mouseX, int mouseY) {
        String s = this.title.func_150254_d();
        int sw = this.font.func_78256_a(s);
        this.font.func_175063_a(s, (float)(-(sw / 2) + this.field_146999_f / 2), -14.0f, 0x777777);
    }

    @Override
    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(partialTicks, mouseX, mouseY);
        if (this.configVisible) {
            this.bindTexture(this.getConfigBackGround());
        } else {
            this.bindTexture(this.getMachineBackGround());
        }
        this.blit(this.x + 15, this.y, 15, 0, 161, 72);
        this.drawEnergyGauge(0, 0, ((TileBase.EnergyStorage)this.te).getEnergyStorage());
    }

    protected void drawEnergyGauge(int x, int y, Energy energy) {
        if (energy.getCapacity() > 0L) {
            this.bindTexture(this.getBackGround());
            Draw.gaugeV(this.x + 4, this.y + 4, 10, 64, 0, 164, energy);
        }
    }

    @Override
    protected boolean hideSlot(Slot slot) {
        return slot instanceof SlotBase && this.configVisible || super.hideSlot(slot);
    }

    @Override
    protected void func_191948_b(int mouseX, int mouseY) {
        ArrayList<String> list = new ArrayList<String>();
        ((TileBase.EnergyStorage)this.te).getListedEnergyInfo(list);
        if (!list.isEmpty() && this.isMouseOver(mouseX - 3, mouseY - 3, 12, 66)) {
            this.renderTooltip(list, mouseX, mouseY);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected ResourceLocation getMachineBackGround() {
        return GUI_MACHINE;
    }

    protected ResourceLocation getConfigBackGround() {
        return GUI_MACHINE;
    }

    protected ResourceLocation getWidgetTexture() {
        return GUI_WIDGET;
    }

    @Override
    protected ResourceLocation getBackGround() {
        return GUI_TEXTURE;
    }
}

