/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.energy.Energy;
import owmii.lib.energy.SideConfig;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;

public abstract class AbstractEnergyProviderBlock<E extends IVariant>
extends AbstractEnergyBlock<E> {
    public AbstractEnergyProviderBlock(Block.Properties properties, E variant) {
        super(properties, variant);
    }

    public AbstractEnergyProviderBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public abstract IEnergyProviderConfig<E> getEnergyConfig();

    @Override
    public SideConfig.Type getTransferType() {
        return SideConfig.Type.OUT;
    }

    @Override
    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent("info.lollipop.max.generates", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(this.getEnergyConfig().getGeneration(this.variant))}).func_211708_a(TextFormatting.GRAY));
    }
}

