/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.shapes.Scan;
import mcjty.rftoolsbuilder.shapes.ScanExtraData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ScanDataManager
extends AbstractWorldData<ScanDataManager> {
    private static final String SCANDATA_NETWORK_NAME = "RFToolsScanData";
    private int lastId = 0;
    private final Map<Integer, Scan> scans = new HashMap<Integer, Scan>();
    private final Map<Integer, ScanExtraData> scanData = new HashMap<Integer, ScanExtraData>();

    public ScanDataManager() {
        super(SCANDATA_NETWORK_NAME);
    }

    public void save(int scanId) {
        ServerWorld world = WorldTools.getOverworld();
        File dataDir = new File(world.func_217485_w().func_75765_b(), "rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, "scan" + scanId);
        Scan scan = this.getOrCreateScan(scanId);
        CompoundNBT tc = new CompoundNBT();
        scan.writeToNBTExternal(tc);
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));){
            CompressedStreamTools.func_74799_a((CompoundNBT)tc, (OutputStream)dataoutputstream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error writing to file 'scan" + scan + "'!", e);
        }
        this.save();
    }

    public ScanExtraData getExtraData(int id) {
        ScanExtraData data = this.scanData.get(id);
        if (data == null) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        } else if (data.getBirthTime() + (long)((Integer)ScannerConfiguration.ticksPerLocatorScan.get() * 100) < System.currentTimeMillis()) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        }
        return data;
    }

    public static ScanDataManager get(World world) {
        return (ScanDataManager)ScanDataManager.getData((World)world, ScanDataManager::new, (String)SCANDATA_NETWORK_NAME);
    }

    @Nonnull
    public Scan getOrCreateScan(int id) {
        Scan scan = this.scans.get(id);
        if (scan == null) {
            scan = new Scan();
            this.scans.put(id, scan);
        }
        return scan;
    }

    @Nonnull
    public Scan loadScan(int id) {
        ServerWorld world = WorldTools.getOverworld();
        Scan scan = this.scans.get(id);
        if (scan == null || scan.getDataInt() == null) {
            if (scan == null) {
                scan = new Scan();
            }
            File dataDir = new File(world.func_217485_w().func_75765_b(), "rftoolsscans");
            dataDir.mkdirs();
            File file = new File(dataDir, "scan" + id);
            if (file.exists()) {
                try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                    CompoundNBT tag = CompressedStreamTools.func_74796_a((InputStream)datainputstream);
                    scan.readFromNBTExternal(tag);
                }
                catch (IOException e) {
                    Logging.log((String)("Error reading scan file for id: " + id));
                }
            }
        }
        return scan;
    }

    public static void listScans(PlayerEntity sender) {
        ScanDataManager scans = ScanDataManager.get(sender.func_130014_f_());
        for (Map.Entry<Integer, Scan> entry : scans.scans.entrySet()) {
            Integer scanid = entry.getKey();
            scans.loadScan(scanid);
            Scan scan = entry.getValue();
            BlockPos dim = scan.getDataDim();
            if (dim == null) {
                sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Scan: " + TextFormatting.WHITE + scanid + TextFormatting.RED + "   Invalid"));
                continue;
            }
            sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Scan: " + TextFormatting.WHITE + scanid + TextFormatting.YELLOW + "   Dim: " + TextFormatting.WHITE + dim.func_177958_n() + "," + dim.func_177956_o() + "," + dim.func_177952_p() + TextFormatting.YELLOW + "   Size: " + TextFormatting.WHITE + scan.getRledata().length + " bytes"));
        }
    }

    public int newScan(World world) {
        ++this.lastId;
        this.save();
        return this.lastId;
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.scans.clear();
        ListNBT lst = tagCompound.func_150295_c("scans", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("scan");
            Scan scan = new Scan();
            scan.readFromNBT(tc);
            this.scans.put(id, scan);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT lst = new ListNBT();
        for (Map.Entry<Integer, Scan> entry : this.scans.entrySet()) {
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("scan", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("scans", (INBT)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }
}

