/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ShieldProjectorBlock
extends BaseBlock
implements INBTPreservingIngredient {
    private final int max;

    public ShieldProjectorBlock(Supplier<TileEntity> te, int max) {
        super(new BlockBuilder().tileEntitySupplier(te));
        this.max = max;
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> list, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, list, advanced);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Supports " + this.max + " blocks"));
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This machine forms a shield out of adjacent"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "template blocks. It can filter based on type of"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "mob and do various things (damage, solid, ...)"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Use the Smart Wrench to add sections to the shield"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Note: block mimic is not implemented yet!"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption and"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "increased damage."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    public Collection<String> getTagsToPreserve() {
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        this.setOwner(world, pos, placer);
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            this.composeDecomposeShield(world, pos, true);
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        this.composeDecomposeShield(world, pos, false);
        return true;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            GlobalCoordinate currentBlock = SmartWrenchItem.getCurrentBlock((ItemStack)player.func_184586_b(Hand.MAIN_HAND));
            if (currentBlock == null) {
                SmartWrenchItem.setCurrentBlock((ItemStack)player.func_184586_b(Hand.MAIN_HAND), (GlobalCoordinate)new GlobalCoordinate(pos, world.func_201675_m().func_186058_p()));
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock((ItemStack)player.func_184586_b(Hand.MAIN_HAND), null);
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    private void composeDecomposeShield(World world, BlockPos pos, boolean ctrl) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ShieldProjectorTileEntity) {
            ((ShieldProjectorTileEntity)te).composeDecomposeShield(ctrl);
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        if (newstate.func_177230_c() != this) {
            this.removeShield((IWorld)world, pos);
        }
        super.func_196243_a(state, world, pos, newstate, isMoving);
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        this.removeShield(world, pos);
        super.func_176206_d(world, pos, state);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        this.removeShield((IWorld)world, pos);
        super.func_180652_a(world, pos, explosionIn);
    }

    private void removeShield(IWorld world, BlockPos pos) {
        ShieldProjectorTileEntity shieldTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShieldProjectorTileEntity && !world.func_201672_e().field_72995_K && (shieldTileEntity = (ShieldProjectorTileEntity)te).isShieldComposed()) {
            shieldTileEntity.decomposeShield();
        }
    }
}

