/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class GuiChamberDetails
extends GuiItemScreen {
    private static final int CHAMBER_XSIZE = 390;
    private static final int CHAMBER_YSIZE = 210;
    private static Map<BlockState, Integer> items = null;
    private static Map<BlockState, Integer> costs = null;
    private static Map<BlockState, ItemStack> stacks = null;
    private static Map<String, Integer> entities = null;
    private static Map<String, Integer> entityCosts = null;
    private static Map<String, Entity> realEntities = null;
    private static Map<String, String> playerNames = null;
    private WidgetList blockList;
    private Label infoLabel;
    private Label info2Label;

    public GuiChamberDetails() {
        super((ModBase)RFToolsBuilder.instance, RFToolsBuilderMessages.INSTANCE, 390, 210, 0, "chambercard");
        this.requestChamberInfoFromServer();
    }

    public static void setItemsWithCount(Map<BlockState, Integer> items, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities, Map<String, String> playerNames) {
        GuiChamberDetails.items = new HashMap<BlockState, Integer>(items);
        GuiChamberDetails.costs = new HashMap<BlockState, Integer>(costs);
        GuiChamberDetails.stacks = new HashMap<BlockState, ItemStack>(stacks);
        GuiChamberDetails.entities = new HashMap<String, Integer>(entities);
        GuiChamberDetails.entityCosts = new HashMap<String, Integer>(entityCosts);
        GuiChamberDetails.realEntities = new HashMap<String, Entity>(realEntities);
        GuiChamberDetails.playerNames = new HashMap<String, String>(playerNames);
    }

    private void requestChamberInfoFromServer() {
        RFToolsBuilderMessages.sendToServer("getChamberInfo");
    }

    public void init() {
        super.init();
        this.blockList = (WidgetList)new WidgetList(this.minecraft, (Screen)this).setName("blocks");
        Slider listSlider = ((Slider)new Slider(this.minecraft, (Screen)this).setDesiredWidth(10)).setVertical().setScrollableName("blocks");
        Panel listPanel = (Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChildren(new Widget[]{this.blockList, listSlider});
        this.infoLabel = (Label)new Label(this.minecraft, (Screen)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.infoLabel.setDesiredWidth(380)).setDesiredHeight(14);
        this.info2Label = (Label)new Label(this.minecraft, (Screen)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.info2Label.setDesiredWidth(380)).setDesiredHeight(14);
        Panel toplevel = (Panel)((Panel)new Panel(this.minecraft, (Screen)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(3)).addChildren(new Widget[]{listPanel, this.infoLabel, this.info2Label});
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void populateLists() {
        this.blockList.removeChildren();
        if (items == null) {
            return;
        }
        int totalCost = 0;
        for (Map.Entry<BlockState, Integer> entry : items.entrySet()) {
            BlockState bm = entry.getKey();
            int count = entry.getValue();
            int cost = costs.get(bm);
            Panel panel = (Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            ItemStack stack = stacks.containsKey(bm) ? stacks.get(bm) : new ItemStack((IItemProvider)bm.func_177230_c(), 0);
            BlockRender blockRender = new BlockRender(this.minecraft, (Screen)this).setRenderItem((Object)stack).setOffsetX(-1).setOffsetY(-1);
            Label nameLabel = (Label)((Label)new Label(this.minecraft, (Screen)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setColor(StyleConfig.colorTextInListNormal);
            if (stack.func_77973_b() == null) {
                ((Label)nameLabel.setText("?")).setDesiredWidth(160);
            } else {
                ((Label)nameLabel.setText(stack.func_200301_q().func_150254_d())).setDesiredWidth(160);
            }
            Label countLabel = (Label)((Label)new Label(this.minecraft, (Screen)this).setText(String.valueOf(count))).setColor(StyleConfig.colorTextInListNormal);
            ((Label)countLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(50);
            Label costLabel = (Label)new Label(this.minecraft, (Screen)this).setColor(StyleConfig.colorTextInListNormal);
            costLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.setText("NOT MOVABLE!");
            } else {
                costLabel.setText("Move Cost " + cost + " RF");
                totalCost += cost;
            }
            panel.addChildren(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.addChild((Widget)panel);
        }
        int totalCostEntities = 0;
        RenderHelper.rot += 0.5f;
        for (Map.Entry<String, Integer> entry : entities.entrySet()) {
            String className = entry.getKey();
            int count = entry.getValue();
            int cost = entityCosts.get(className);
            Panel panel = (Panel)new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            String entityName = "<?>";
            Entity entity = null;
            if (realEntities.containsKey(className)) {
                entity = realEntities.get(className);
            } else {
                try {
                    Class<?> aClass = Class.forName(className);
                    entity = (Entity)aClass.getConstructor(World.class).newInstance(this.minecraft.field_71441_e);
                    entityName = aClass.getSimpleName();
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (InstantiationException aClass) {
                }
                catch (IllegalAccessException aClass) {
                }
                catch (InvocationTargetException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            if (playerNames.containsKey(className)) {
                entityName = playerNames.get(className);
            }
            BlockRender blockRender = new BlockRender(this.minecraft, (Screen)this).setRenderItem((Object)entity).setOffsetX(-1).setOffsetY(-1);
            Label nameLabel = (Label)new Label(this.minecraft, (Screen)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            ((Label)nameLabel.setText(entityName)).setDesiredWidth(160);
            Label countLabel = (Label)new Label(this.minecraft, (Screen)this).setText(String.valueOf(count));
            ((Label)countLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(50);
            Label costLabel = new Label(this.minecraft, (Screen)this);
            costLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.setText("NOT MOVABLE!");
            } else {
                costLabel.setText("Move Cost " + cost + " RF");
                totalCostEntities += cost;
            }
            panel.addChildren(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.addChild((Widget)panel);
        }
        this.infoLabel.setText("Total cost blocks: " + totalCost + " RF");
        this.info2Label.setText("Total cost entities: " + totalCostEntities + " RF");
    }

    public void render(int xSize_lo, int ySize_lo, float par3) {
        super.render(xSize_lo, ySize_lo, par3);
        this.populateLists();
        this.drawWindow();
    }
}

