/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;

public final class TextUtil {
    private static final String ENERGY_FORMAT = "%,d";

    private TextUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static ITextComponent translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "supermultidrills", suffix);
        return new TranslationTextComponent(key, params);
    }

    public static ITextComponent energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return TextUtil.translate("misc", "energy", s1);
    }

    public static ITextComponent energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return TextUtil.translate("misc", "energyWithMax", s1, s2);
    }

    public static void addEnergyInfo(ItemStack stack, List<ITextComponent> tooltip) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> tooltip.add(TextUtil.energyWithMax(e.getEnergyStored(), e.getMaxEnergyStored())));
    }
}

