/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.api.harvesting.HoeHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;

@ObjectHolder(value="pneumaticcraft")
public class ModRegistries {
    public static IForgeRegistry<HarvestHandler> HARVEST_HANDLERS = null;
    public static IForgeRegistry<HoeHandler> HOE_HANDLERS = null;
    public static IForgeRegistry<ProgWidgetType<?>> PROG_WIDGETS = null;

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        @SubscribeEvent
        public static void register(RegistryEvent.NewRegistry event) {
            HARVEST_HANDLERS = Registration.makeRegistry("harvest_handlers", HarvestHandler.class).create();
            HOE_HANDLERS = Registration.makeRegistry("hoe_handlers", HoeHandler.class).create();
            Registration.makeRegistry("prog_widgets", ProgWidgetType.class).create();
            PROG_WIDGETS = RegistryManager.ACTIVE.getRegistry(PneumaticCraftUtils.RL("prog_widgets"));
        }

        private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(String name, Class<T> type) {
            return new RegistryBuilder().setName(PneumaticCraftUtils.RL(name)).setType(type).setMaxID(0x7FFFFFFE).disableSaving();
        }
    }
}

