/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.GuiRegistry;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RenderAssemblyIOUnit
extends AbstractTileModelRenderer<TileEntityAssemblyIOUnit> {
    private final ModelRenderer baseTurn = new ModelRenderer(64, 64, 0, 17);
    private final ModelRenderer baseTurn2;
    private final ModelRenderer armBase1;
    private final ModelRenderer armBase2;
    private final ModelRenderer supportMiddle;
    private final ModelRenderer armMiddle1;
    private final ModelRenderer armMiddle2;
    private final ModelRenderer clawBase;
    private final ModelRenderer clawAxle;
    private final ModelRenderer clawTurn;
    private final ModelRenderer claw1;
    private final ModelRenderer claw2;
    private static final float ITEM_SCALE = 0.5f;

    public RenderAssemblyIOUnit(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.baseTurn.func_228300_a_(0.0f, 0.0f, 0.0f, 7.0f, 1.0f, 7.0f);
        this.baseTurn.func_78793_a(-3.5f, 22.0f, -3.5f);
        this.baseTurn.field_78809_i = true;
        this.baseTurn2 = new ModelRenderer(64, 64, 28, 17);
        this.baseTurn2.func_228300_a_(0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f);
        this.baseTurn2.func_78793_a(-2.0f, 17.0f, -2.0f);
        this.baseTurn2.field_78809_i = true;
        this.armBase1 = new ModelRenderer(64, 64, 0, 25);
        this.armBase1.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 8.0f);
        this.armBase1.func_78793_a(2.0f, 17.0f, -1.0f);
        this.armBase1.field_78809_i = true;
        this.armBase2 = new ModelRenderer(64, 64, 0, 25);
        this.armBase2.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 8.0f);
        this.armBase2.func_78793_a(-3.0f, 17.0f, -1.0f);
        this.armBase2.field_78809_i = true;
        this.supportMiddle = new ModelRenderer(64, 64, 0, 57);
        this.supportMiddle.func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f);
        this.supportMiddle.func_78793_a(-1.0f, 17.5f, 5.5f);
        this.supportMiddle.field_78809_i = true;
        this.armMiddle1 = new ModelRenderer(64, 64, 0, 35);
        this.armMiddle1.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 17.0f, 2.0f);
        this.armMiddle1.func_78793_a(-2.0f, 2.0f, 5.0f);
        this.armMiddle1.field_78809_i = true;
        this.armMiddle2 = new ModelRenderer(64, 64, 0, 35);
        this.armMiddle2.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 17.0f, 2.0f);
        this.armMiddle2.func_78793_a(1.0f, 2.0f, 5.0f);
        this.armMiddle2.field_78809_i = true;
        this.clawBase = new ModelRenderer(64, 64, 8, 38);
        this.clawBase.func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 3.0f);
        this.clawBase.func_78793_a(-1.0f, 2.0f, 4.5f);
        this.clawBase.field_78809_i = true;
        this.clawAxle = new ModelRenderer(64, 64, 8, 45);
        this.clawAxle.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.clawAxle.func_78793_a(-0.5f, 2.5f, 4.0f);
        this.clawAxle.field_78809_i = true;
        this.clawTurn = new ModelRenderer(64, 64, 8, 49);
        this.clawTurn.func_228300_a_(0.0f, 0.0f, 0.0f, 4.0f, 2.0f, 1.0f);
        this.clawTurn.func_78793_a(-2.0f, 2.0f, 3.0f);
        this.clawTurn.field_78809_i = true;
        this.claw1 = new ModelRenderer(64, 64, 8, 54);
        this.claw1.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        this.claw1.func_78793_a(0.0f, 2.0f, 2.0f);
        this.claw1.field_78809_i = true;
        this.claw2 = new ModelRenderer(64, 64, 8, 59);
        this.claw2.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        this.claw2.func_78793_a(-1.0f, 2.0f, 2.0f);
        this.claw2.field_78809_i = true;
    }

    @Override
    void renderModel(TileEntityAssemblyIOUnit te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IAssemblyRenderOverriding renderOverride;
        float[] angles = new float[5];
        for (int i = 0; i < 5; ++i) {
            angles[i] = te.oldAngles[i] + (te.angles[i] - te.oldAngles[i]) * partialTicks;
        }
        ItemStack heldStack = te.getPrimaryInventory().getStackInSlot(0);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture(te)));
        Pair<IAssemblyRenderOverriding, Float> clawTranslation = this.getClawTranslation(MathHelper.func_219799_g((float)partialTicks, (float)te.oldClawProgress, (float)te.clawProgress), heldStack);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angles[0]));
        this.baseTurn.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.baseTurn2.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_(0.0, 1.125, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(angles[1]));
        matrixStackIn.func_227861_a_(0.0, -1.125, 0.0);
        this.armBase1.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.armBase2.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.supportMiddle.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_(0.0, 1.125, 0.375);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(angles[2]));
        matrixStackIn.func_227861_a_(0.0, -1.125, -0.375);
        this.armMiddle1.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.armMiddle2.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_(0.0, 0.1875, 0.375);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(angles[3]));
        matrixStackIn.func_227861_a_(0.0, -0.1875, -0.375);
        this.clawBase.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_(0.0, 0.1875, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angles[4]));
        matrixStackIn.func_227861_a_(0.0, -0.1875, 0.0);
        this.clawAxle.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.clawTurn.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)((Float)clawTranslation.getRight()).floatValue(), 0.0, 0.0);
        this.claw1.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_((double)(-2.0f * ((Float)clawTranslation.getRight()).floatValue()), 0.0, 0.0);
        this.claw2.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        if (!heldStack.func_190926_b() && ((renderOverride = (IAssemblyRenderOverriding)clawTranslation.getLeft()) == null || renderOverride.applyRenderChangeIOUnit(matrixStackIn, heldStack))) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            double yOffset = heldStack.func_77973_b() instanceof BlockItem ? 0.09375 : 0.03125;
            matrixStackIn.func_227861_a_(0.0, yOffset, -0.1875);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel ibakedmodel = itemRenderer.func_184393_a(heldStack, te.func_145831_w(), null);
            itemRenderer.func_229111_a_(heldStack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
        }
    }

    private Pair<IAssemblyRenderOverriding, Float> getClawTranslation(float clawProgress, ItemStack heldStack) {
        IAssemblyRenderOverriding renderOverride = null;
        float clawTrans = !heldStack.func_190926_b() ? ((renderOverride = GuiRegistry.renderOverrides.get(heldStack.func_77973_b().getRegistryName())) != null ? renderOverride.getIOUnitClawShift(heldStack) : (heldStack.func_77973_b() instanceof BlockItem ? 0.09375f - clawProgress * 0.1f / 16.0f : 0.09375f - clawProgress * 1.4f / 16.0f)) : 0.09375f - clawProgress * 1.5f / 16.0f;
        return Pair.of((Object)renderOverride, (Object)Float.valueOf(clawTrans));
    }

    private ResourceLocation getTexture(TileEntityAssemblyIOUnit te) {
        return te != null && te.isImportUnit() ? Textures.MODEL_ASSEMBLY_IO_IMPORT : Textures.MODEL_ASSEMBLY_IO_EXPORT;
    }
}

