/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetColorSelector;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class GuiRedstoneModule
extends GuiTubeModule {
    private WidgetComboBox comboBox;
    private WidgetLabel constLabel;
    private WidgetTextFieldNumber textField;
    private WidgetLabel otherColorLabel;
    private WidgetColorSelector otherColorButton;
    private int ourColor;
    private int otherColor;
    private WidgetCheckBox invertCheckBox;
    private boolean upgraded;
    private boolean output;
    private final List<String> lowerText = new ArrayList<String>();

    public GuiRedstoneModule(BlockPos modulePos) {
        super(modulePos);
        this.ySize = ((ModuleRedstone)this.module).getRedstoneDirection() == ModuleRedstone.EnumRedstoneDirection.OUTPUT ? 202 : 57;
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.output ? Textures.GUI_WIDGET_OPTIONS : Textures.GUI_MODULE_SIMPLE;
    }

    @Override
    public void init() {
        super.init();
        ModuleRedstone mr = (ModuleRedstone)this.module;
        this.upgraded = mr.isUpgraded();
        this.output = mr.getRedstoneDirection() == ModuleRedstone.EnumRedstoneDirection.OUTPUT;
        this.ourColor = mr.getColorChannel();
        this.otherColor = mr.getOtherColor();
        this.addButton(new WidgetLabel(this.guiLeft + this.xSize / 2, this.guiTop + 5, this.getTitle().func_150254_d()).setAlignment(WidgetLabel.Alignment.CENTRE));
        WidgetLabel ourColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 25, I18n.func_135052_a((String)"gui.tubeModule.channel", (Object[])new Object[0]));
        this.addButton(ourColorLabel);
        WidgetLabel opLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 45, I18n.func_135052_a((String)"gui.redstoneModule.operation", (Object[])new Object[0]));
        this.addButton(opLabel);
        opLabel.visible = this.output;
        this.otherColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 65, I18n.func_135052_a((String)"gui.tubeModule.otherChannel", (Object[])new Object[0]));
        this.otherColorLabel.visible = this.output;
        this.addButton(this.otherColorLabel);
        this.constLabel = new WidgetLabel(this.guiLeft + 15, this.guiTop + 65, I18n.func_135052_a((String)"gui.redstoneModule.constant", (Object[])new Object[0]));
        this.addButton(this.constLabel);
        this.constLabel.visible = this.output;
        int w = 0;
        for (WidgetLabel label : ImmutableList.of((Object)ourColorLabel, (Object)this.otherColorLabel, (Object)opLabel, (Object)this.constLabel)) {
            w = Math.max(label.getWidth(), w);
        }
        int xBase = this.guiLeft + w + 15;
        this.addButton((Widget)new WidgetColorSelector(xBase, this.guiTop + 20, b -> {
            this.ourColor = b.getColor().func_196059_a();
        }).withInitialColor(DyeColor.func_196056_a((int)this.ourColor)));
        if (!this.output) {
            return;
        }
        ArrayList<String> ops = new ArrayList<String>();
        for (ModuleRedstone.Operation op : ModuleRedstone.Operation.values()) {
            ops.add(I18n.func_135052_a((String)op.getTranslationKey(), (Object[])new Object[0]));
        }
        this.comboBox = new WidgetComboBox(this.font, xBase, this.guiTop + 43, this.xSize - xBase + this.guiLeft - 10, 12).setFixedOptions().setShouldSort(false).setElements(ops);
        this.comboBox.selectElement(mr.getOperation().ordinal());
        this.comboBox.active = this.upgraded;
        this.addButton((Widget)this.comboBox);
        this.otherColorButton = new WidgetColorSelector(xBase, this.guiTop + 60, b -> {
            this.otherColor = b.getColor().func_196059_a();
        }).withInitialColor(DyeColor.func_196056_a((int)this.otherColor));
        this.otherColorButton.active = this.upgraded;
        this.addButton((Widget)this.otherColorButton);
        this.textField = new WidgetTextFieldNumber(this.font, xBase, this.guiTop + 63, 30, 12);
        this.textField.minValue = 0;
        this.textField.setDecimals(0);
        this.textField.setValue(mr.getConstantVal());
        this.textField.active = this.upgraded;
        this.addButton((Widget)this.textField);
        this.invertCheckBox = new WidgetCheckBox(this.guiLeft + 10, this.guiTop + 85, -12566464, I18n.func_135052_a((String)"gui.redstoneModule.invert", (Object[])new Object[0])){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (GuiRedstoneModule.this.comboBox.isFocused()) {
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        };
        this.invertCheckBox.checked = mr.isInverted();
        this.invertCheckBox.setTooltip(I18n.func_135052_a((String)"gui.redstoneModule.invert.tooltip", (Object[])new Object[0]));
        this.addButton(this.invertCheckBox);
        this.updateWidgetVisibility();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.output) {
            if (this.upgraded) {
                this.updateWidgetVisibility();
            }
            this.updateLowerText();
        }
    }

    private void updateWidgetVisibility() {
        ModuleRedstone.Operation op = this.getSelectedOp();
        this.constLabel.visible = op.useConst();
        this.textField.func_146189_e(op.useConst());
        this.otherColorLabel.visible = op.useOtherColor();
        this.otherColorButton.visible = op.useOtherColor();
        this.otherColorButton.setVisible(op.useOtherColor());
    }

    private void updateLowerText() {
        this.lowerText.clear();
        ModuleRedstone.Operation op = this.getSelectedOp();
        String key = op.getTranslationKey() + ".tooltip";
        String s = op.useConst() ? I18n.func_135052_a((String)key, (Object[])new Object[]{PneumaticCraftUtils.dyeColorDesc(this.ourColor), this.textField.getValue()}) : (op.useOtherColor() ? I18n.func_135052_a((String)key, (Object[])new Object[]{PneumaticCraftUtils.dyeColorDesc(this.ourColor), PneumaticCraftUtils.dyeColorDesc(this.otherColor)}) : I18n.func_135052_a((String)key, (Object[])new Object[]{PneumaticCraftUtils.dyeColorDesc(this.ourColor)}));
        this.lowerText.addAll(PneumaticCraftUtils.splitString(s, 30));
        if (!this.upgraded) {
            List extra = PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"gui.redstoneModule.addAdvancedPCB", (Object[])new Object[0]), 30).stream().map(str -> TextFormatting.DARK_BLUE + str).collect(Collectors.toList());
            this.lowerText.addAll(extra);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        int n = this.lowerText.size();
        this.font.getClass();
        int yBase = this.guiTop + this.ySize - n * 9 - 10;
        for (int i = 0; i < this.lowerText.size(); ++i) {
            float f = this.guiLeft + 10;
            this.font.getClass();
            this.font.func_211126_b(this.lowerText.get(i), f, (float)(yBase + i * 9), -12566464);
        }
    }

    private ModuleRedstone.Operation getSelectedOp() {
        return ModuleRedstone.Operation.values()[this.comboBox.getSelectedElementIndex()];
    }

    public void onClose() {
        super.onClose();
        ((ModuleRedstone)this.module).setColorChannel(this.ourColor);
        if (this.output) {
            ((ModuleRedstone)this.module).setInverted(this.invertCheckBox.checked);
            ((ModuleRedstone)this.module).setOperation(this.getSelectedOp(), this.otherColor, this.textField.getValue());
        }
        NetworkHandler.sendToServer(new PacketSyncRedstoneModuleToServer((ModuleRedstone)this.module));
    }
}

