/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityItemDistributor;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityNatureAltar;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityRFConverter;
import de.ellpeck.naturesaura.enchant.ModEnchantment;
import de.ellpeck.naturesaura.items.ItemAuraCache;
import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.particles.ParticleHandler;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    public static final ResourceLocation OVERLAYS = new ResourceLocation("naturesaura", "textures/gui/overlays.png");
    public static final ResourceLocation BOOK_GUI = new ResourceLocation("naturesaura", "textures/gui/book.png");
    public static final List<PacketAuraChunk> PENDING_AURA_CHUNKS = new ArrayList<PacketAuraChunk>();
    private static final ItemStack ITEM_FRAME = new ItemStack((IItemProvider)Items.field_151160_bD);
    private static final ItemStack DISPENSER = new ItemStack((IItemProvider)Blocks.field_150367_z);
    private static final Map<ResourceLocation, Tuple<ItemStack, Boolean>> SHOWING_EFFECTS = new HashMap<ResourceLocation, Tuple<ItemStack, Boolean>>();
    private static ItemStack heldCache = ItemStack.field_190927_a;
    private static ItemStack heldEye = ItemStack.field_190927_a;
    private static ItemStack heldOcular = ItemStack.field_190927_a;

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (ModList.get().isLoaded("enchdesc")) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (!(enchantment instanceof ModEnchantment)) continue;
            String info = I18n.func_135052_a((String)(enchantment.func_77320_a() + ".desc"), (Object[])new Object[0]);
            List split = Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 250);
            ITextComponent name = enchantment.func_200305_d(((Integer)entry.getValue()).intValue());
            int addIndex = tooltip.indexOf(name) + 1;
            for (int i = split.size() - 1; i >= 0; --i) {
                tooltip.add(addIndex, new StringTextComponent(TextFormatting.DARK_GRAY + (String)split.get(i)));
            }
        }
    }

    @SubscribeEvent
    public void onDebugRender(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P && ((Boolean)ModConfig.instance.debugText.get()).booleanValue()) {
            String prefix = TextFormatting.GREEN + "[" + "Nature's Aura" + "]" + TextFormatting.RESET + " ";
            ArrayList left = event.getLeft();
            left.add("");
            int depth = ParticleHandler.getParticleAmount(true);
            int noDepth = ParticleHandler.getParticleAmount(false);
            left.add(prefix + "P: " + (depth + noDepth) + " (D: " + depth + " nD: " + noDepth + ")");
            if (mc.field_71439_g.func_184812_l_()) {
                MutableInt amount = new MutableInt(1000000);
                MutableInt spots = new MutableInt();
                IAuraChunk.getSpotsInArea((IWorld)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 35, (blockPos, drainSpot) -> {
                    spots.increment();
                    amount.add((Number)drainSpot);
                });
                NumberFormat format = NumberFormat.getInstance();
                left.add(prefix + "A: " + format.format(amount.intValue()) + " (S: " + spots.intValue() + ")");
                left.add(prefix + "AT: " + IAuraType.forWorld((IWorld)mc.field_71441_e).getName());
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            heldCache = ItemStack.field_190927_a;
            heldEye = ItemStack.field_190927_a;
            heldOcular = ItemStack.field_190927_a;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                ParticleHandler.clearParticles();
                ItemRangeVisualizer.clear();
                PENDING_AURA_CHUNKS.clear();
            } else {
                PENDING_AURA_CHUNKS.removeIf(next -> next.tryHandle((World)mc.field_71441_e));
                if (!mc.func_147113_T()) {
                    if (mc.field_71441_e.func_82737_E() % 20L == 0L) {
                        int amount = MathHelper.func_76128_c((double)(190.0 * (Double)ModConfig.instance.excessParticleAmount.get()));
                        for (int i = 0; i < amount; ++i) {
                            int chance;
                            int excess;
                            int z;
                            int x = MathHelper.func_76128_c((double)mc.field_71439_g.func_226277_ct_()) + mc.field_71441_e.field_73012_v.nextInt(64) - 32;
                            BlockPos pos = new BlockPos(x, mc.field_71441_e.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = MathHelper.func_76128_c((double)mc.field_71439_g.func_226281_cx_()) + mc.field_71441_e.field_73012_v.nextInt(64) - 32) - 1, z);
                            BlockState state = mc.field_71441_e.func_180495_p(pos);
                            Block block = state.func_177230_c();
                            if (!(block instanceof IGrowable) && !(block instanceof IPlantable) && !(block instanceof LeavesBlock) || (excess = IAuraChunk.triangulateAuraInArea((IWorld)mc.field_71441_e, pos, 45) - 1000000) <= 0 || mc.field_71441_e.field_73012_v.nextInt(chance = Math.max(10, 50 - excess / 25000)) > 0) continue;
                            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + mc.field_71441_e.field_73012_v.nextFloat(), (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + mc.field_71441_e.field_73012_v.nextFloat(), mc.field_71441_e.field_73012_v.nextGaussian() * (double)0.01f, mc.field_71441_e.field_73012_v.nextFloat() * 0.025f, mc.field_71441_e.field_73012_v.nextGaussian() * (double)0.01f, BiomeColors.func_228361_b_((ILightReader)mc.field_71441_e, (BlockPos)pos), Math.min(2.0f, 1.0f + mc.field_71441_e.field_73012_v.nextFloat() * ((float)excess / 30000.0f)), Math.min(300, 100 + mc.field_71441_e.field_73012_v.nextInt(excess / 3000 + 1)), 0.0f, false, true);
                        }
                    }
                    if (Helper.isHoldingItem((PlayerEntity)mc.field_71439_g, ModItems.RANGE_VISUALIZER) && mc.field_71441_e.func_82737_E() % 5L == 0L) {
                        NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
                        inst.setParticleSpawnRange(512);
                        inst.setParticleDepth(false);
                        for (BlockPos pos : ItemRangeVisualizer.VISUALIZED_RAILS.get((Object)mc.field_71441_e.func_201675_m().func_186058_p())) {
                            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + mc.field_71441_e.field_73012_v.nextFloat(), (float)pos.func_177956_o() + mc.field_71441_e.field_73012_v.nextFloat(), (float)pos.func_177952_p() + mc.field_71441_e.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 14744319, mc.field_71441_e.field_73012_v.nextFloat() * 5.0f + 1.0f, 100, 0.0f, false, true);
                        }
                        inst.setParticleDepth(true);
                        inst.setParticleSpawnRange(32);
                    }
                    ParticleHandler.updateParticles();
                    heldCache = Helper.getEquippedItem(s -> s.func_77973_b() instanceof ItemAuraCache, (PlayerEntity)mc.field_71439_g);
                    heldEye = Helper.getEquippedItem(s -> s.func_77973_b() == ModItems.EYE, (PlayerEntity)mc.field_71439_g);
                    heldOcular = Helper.getEquippedItem(s -> s.func_77973_b() == ModItems.EYE_IMPROVED, (PlayerEntity)mc.field_71439_g);
                    if (!heldOcular.func_190926_b() && mc.field_71441_e.func_82737_E() % 20L == 0L) {
                        SHOWING_EFFECTS.clear();
                        Helper.getAuraChunksInArea((World)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 100, chunk -> chunk.getActiveEffectIcons((PlayerEntity)mc.field_71439_g, SHOWING_EFFECTS));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ParticleHandler.renderParticles(event.getMatrixStack(), mc.func_184121_ak());
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)event.getMatrixStack().func_227866_c_().func_227870_a_());
        ActiveRenderInfo info = mc.field_71460_t.func_215316_n();
        Vec3d view = info.func_216785_c();
        GL11.glTranslated((double)(-view.func_82615_a()), (double)(-view.func_82617_b()), (double)(-view.func_82616_c()));
        if (mc.field_71474_y.field_74330_P && mc.field_71439_g.func_184812_l_() && ((Boolean)ModConfig.instance.debugWorld.get()).booleanValue()) {
            HashMap spots = new HashMap();
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBegin((int)7);
            IAuraChunk.getSpotsInArea((IWorld)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 64, (pos, spot) -> {
                spots.put(pos, spot);
                RenderSystem.color4f((float)(spot > 0 ? 0.0f : 1.0f), (float)(spot > 0 ? 1.0f : 0.0f), (float)0.0f, (float)0.35f);
                Helper.renderWeirdBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0, 1.0, 1.0);
            });
            GL11.glEnd();
            GL11.glPopAttrib();
            float scale = 0.03f;
            NumberFormat format = NumberFormat.getInstance();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            for (Map.Entry spot2 : spots.entrySet()) {
                BlockPos pos2 = (BlockPos)spot2.getKey();
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)(((double)pos2.func_177958_n() + 0.1) / (double)scale), (double)(((double)pos2.func_177956_o() + 1.001) / (double)scale), (double)(((double)pos2.func_177952_p() + 0.1) / (double)scale));
                RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderSystem.scalef((float)0.65f, (float)0.65f, (float)0.65f);
                mc.field_71466_p.func_211126_b(format.format(spot2.getValue()), 0.0f, 0.0f, 0);
                RenderSystem.popMatrix();
            }
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
        if (Helper.isHoldingItem((PlayerEntity)mc.field_71439_g, ModItems.RANGE_VISUALIZER)) {
            DimensionType dim = mc.field_71441_e.func_201675_m().func_186058_p();
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBegin((int)7);
            for (BlockPos pos3 : ItemRangeVisualizer.VISUALIZED_BLOCKS.get((Object)dim)) {
                BlockState state;
                Block block;
                if (!mc.field_71441_e.func_175667_e(pos3) || !((block = (state = mc.field_71441_e.func_180495_p(pos3)).func_177230_c()) instanceof IVisualizable)) continue;
                this.renderVisualize((IVisualizable)block, (World)mc.field_71441_e, pos3);
            }
            for (Entity entity : ItemRangeVisualizer.VISUALIZED_ENTITIES.get((Object)dim)) {
                if (!entity.func_70089_S() || !(entity instanceof IVisualizable)) continue;
                this.renderVisualize((IVisualizable)entity, (World)mc.field_71441_e, entity.func_180425_c());
            }
            GL11.glEnd();
            GL11.glPopAttrib();
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderVisualize(IVisualizable visualize, World world, BlockPos pos) {
        AxisAlignedBB box = visualize.getVisualizationBounds(world, pos);
        if (box == null) {
            return;
        }
        box = box.func_186662_g((double)0.05f);
        int color = visualize.getVisualizationColor(world, pos);
        RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)0.5f);
        Helper.renderWeirdBox(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d - box.field_72340_a, box.field_72337_e - box.field_72338_b, box.field_72334_f - box.field_72339_c);
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            MainWindow res = event.getWindow();
            if (mc.field_71439_g != null) {
                if (!heldCache.func_190926_b()) {
                    IAuraContainer container = (IAuraContainer)heldCache.getCapability(NaturesAuraAPI.capAuraContainer, null).orElse(null);
                    int width = MathHelper.func_76123_f((float)((float)container.getStoredAura() / (float)container.getMaxAura() * 80.0f));
                    int conf = (Integer)ModConfig.instance.cacheBarLocation.get();
                    int x = res.func_198107_o() / 2 + (conf == 0 ? -173 - (mc.field_71439_g.func_184592_cb().func_190926_b() ? 0 : 29) : 93);
                    int y = res.func_198087_p() - 8;
                    RenderSystem.pushMatrix();
                    int color = container.getAuraColor();
                    RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
                    mc.func_110434_K().func_110577_a(OVERLAYS);
                    if (width < 80) {
                        AbstractGui.blit((int)(x + width), (int)y, (float)width, (float)0.0f, (int)(80 - width), (int)6, (int)256, (int)256);
                    }
                    if (width > 0) {
                        AbstractGui.blit((int)x, (int)y, (float)0.0f, (float)6.0f, (int)width, (int)6, (int)256, (int)256);
                    }
                    float scale = 0.75f;
                    RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                    String s = heldCache.func_200301_q().func_150254_d();
                    mc.field_71466_p.func_175063_a(s, conf == 1 ? (float)x / scale : (float)(x + 80) / scale - (float)mc.field_71466_p.func_78256_a(s), (float)(y - 7) / scale, color);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.popMatrix();
                }
                if (!heldEye.func_190926_b() || !heldOcular.func_190926_b()) {
                    BlockPos pos;
                    RenderSystem.pushMatrix();
                    mc.func_110434_K().func_110577_a(OVERLAYS);
                    int conf = (Integer)ModConfig.instance.auraBarLocation.get();
                    if (!(mc.field_71474_y.field_74330_P || conf == 2 && mc.field_71462_r instanceof ChatScreen)) {
                        int y;
                        int startX;
                        int color = IAuraType.forWorld((IWorld)mc.field_71441_e).getColor();
                        RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
                        int totalAmount = IAuraChunk.triangulateAuraInArea((IWorld)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 35);
                        float totalPercentage = (float)totalAmount / 2000000.0f;
                        String text = I18n.func_135052_a((String)"info.naturesaura.aura_in_area", (Object[])new Object[0]);
                        float textScale = 0.75f;
                        int n = startX = conf % 2 == 0 ? 3 : res.func_198107_o() - 3 - 6;
                        int startY = conf < 2 ? 10 : (!heldOcular.func_190926_b() && (totalPercentage > 1.0f || totalPercentage < 0.0f) ? -26 : 0) + res.func_198087_p() - 60;
                        float plusOffX = conf % 2 == 0 ? 7.0f : -7.0f;
                        float textX = conf % 2 == 0 ? 3.0f : (float)(res.func_198107_o() - 3) - (float)mc.field_71466_p.func_78256_a(text) * textScale;
                        float textY = conf < 2 ? 3.0f : (float)(res.func_198087_p() - 3 - 6);
                        int tHeight = MathHelper.func_76123_f((float)(MathHelper.func_76131_a((float)totalPercentage, (float)0.0f, (float)1.0f) * 50.0f));
                        int n2 = y = !heldOcular.func_190926_b() && totalPercentage > 1.0f ? startY + 26 : startY;
                        if (tHeight < 50) {
                            AbstractGui.blit((int)startX, (int)y, (float)6.0f, (float)12.0f, (int)6, (int)(50 - tHeight), (int)256, (int)256);
                        }
                        if (tHeight > 0) {
                            AbstractGui.blit((int)startX, (int)(y + 50 - tHeight), (float)0.0f, (float)(62 - tHeight), (int)6, (int)tHeight, (int)256, (int)256);
                        }
                        if (!heldOcular.func_190926_b()) {
                            int bottomHeight;
                            int topHeight = MathHelper.func_76123_f((float)(MathHelper.func_76131_a((float)((totalPercentage - 1.0f) * 2.0f), (float)0.0f, (float)1.0f) * 25.0f));
                            if (topHeight > 0) {
                                if (topHeight < 25) {
                                    AbstractGui.blit((int)startX, (int)startY, (float)18.0f, (float)12.0f, (int)6, (int)(25 - topHeight), (int)256, (int)256);
                                }
                                AbstractGui.blit((int)startX, (int)(startY + 25 - topHeight), (float)12.0f, (float)(37 - topHeight), (int)6, (int)topHeight, (int)256, (int)256);
                            }
                            if ((bottomHeight = MathHelper.func_76141_d((float)(MathHelper.func_76131_a((float)((totalPercentage + 1.0f) * 2.0f - 1.0f), (float)0.0f, (float)1.0f) * 25.0f))) < 25) {
                                AbstractGui.blit((int)startX, (int)(startY + 51), (float)18.0f, (float)12.0f, (int)6, (int)(25 - bottomHeight), (int)256, (int)256);
                                if (bottomHeight > 0) {
                                    AbstractGui.blit((int)startX, (int)(startY + 51 + 25 - bottomHeight), (float)12.0f, (float)(37 - bottomHeight), (int)6, (int)bottomHeight, (int)256, (int)256);
                                }
                            }
                        }
                        float f = heldOcular.func_190926_b() ? 1.0f : 1.5f;
                        if (totalPercentage > f) {
                            mc.field_71466_p.func_175063_a("+", (float)startX + plusOffX, (float)startY - 0.5f, color);
                        }
                        float f2 = heldOcular.func_190926_b() ? 0.0f : -0.5f;
                        if (totalPercentage < f2) {
                            mc.field_71466_p.func_175063_a("-", (float)startX + plusOffX, (float)startY - 0.5f + (float)(heldOcular.func_190926_b() ? 44 : 70), color);
                        }
                        RenderSystem.pushMatrix();
                        RenderSystem.scalef((float)textScale, (float)textScale, (float)textScale);
                        mc.field_71466_p.func_175063_a(text, textX / textScale, textY / textScale, color);
                        RenderSystem.popMatrix();
                        if (!heldOcular.func_190926_b()) {
                            float scale = 0.75f;
                            RenderSystem.pushMatrix();
                            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                            int stackX = conf % 2 == 0 ? 10 : res.func_198107_o() - 22;
                            int stackY = conf < 2 ? 15 : res.func_198087_p() - 55;
                            for (Tuple<ItemStack, Boolean> effect : SHOWING_EFFECTS.values()) {
                                int theX = (int)((float)stackX / scale);
                                int theY = (int)((float)stackY / scale);
                                ItemStack stack = (ItemStack)effect.func_76341_a();
                                Helper.renderItemInGui(stack, theX, theY, 1.0f);
                                if (((Boolean)effect.func_76340_b()).booleanValue()) {
                                    GlStateManager.func_227731_j_();
                                    mc.func_110434_K().func_110577_a(OVERLAYS);
                                    AbstractGui.blit((int)theX, (int)theY, (float)240.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                                    GlStateManager.func_227734_k_();
                                }
                                stackY += 8;
                            }
                            RenderSystem.popMatrix();
                        }
                    }
                    if (mc.field_71476_x instanceof BlockRayTraceResult && (pos = ((BlockRayTraceResult)mc.field_71476_x).func_216350_a()) != null) {
                        IAuraContainer container;
                        TileEntity tile = mc.field_71441_e.func_175625_s(pos);
                        int x = res.func_198107_o() / 2;
                        int y = res.func_198087_p() / 2;
                        if (tile != null && (container = (IAuraContainer)tile.getCapability(NaturesAuraAPI.capAuraContainer, null).orElse(null)) != null) {
                            IAuraContainer stackCont;
                            ItemStack tileStack;
                            BlockState state = mc.field_71441_e.func_180495_p(pos);
                            ItemStack blockStack = state.func_177230_c().getPickBlock(state, mc.field_71476_x, (IBlockReader)mc.field_71441_e, pos, (PlayerEntity)mc.field_71439_g);
                            this.drawContainerInfo(container.getStoredAura(), container.getMaxAura(), container.getAuraColor(), mc, res, 35, blockStack.func_200301_q().func_150254_d(), null);
                            if (tile instanceof TileEntityNatureAltar && !(tileStack = ((TileEntityNatureAltar)tile).getItemHandler(null).getStackInSlot(0)).func_190926_b() && (stackCont = (IAuraContainer)tileStack.getCapability(NaturesAuraAPI.capAuraContainer, null).orElse(null)) != null) {
                                this.drawContainerInfo(stackCont.getStoredAura(), stackCont.getMaxAura(), stackCont.getAuraColor(), mc, res, 55, tileStack.func_200301_q().func_150254_d(), null);
                            }
                        } else if (tile instanceof TileEntityRFConverter) {
                            TileEntityRFConverter.RFStorage storage = ((TileEntityRFConverter)tile).storage;
                            this.drawContainerInfo(storage.getEnergyStored(), storage.getMaxEnergyStored(), 13388054, mc, res, 35, I18n.func_135052_a((String)"tile.naturesaura.rf_converter.name", (Object[])new Object[0]), storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF");
                        } else if (tile instanceof TileEntityGratedChute) {
                            TileEntityGratedChute chute = (TileEntityGratedChute)tile;
                            ItemStack stack = chute.getItemHandler(null).getStackInSlot(0);
                            if (stack.func_190926_b()) {
                                mc.field_71466_p.func_175063_a(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"info.naturesaura.empty", (Object[])new Object[0]), (float)(x + 5), (float)(y - 11), 0xFFFFFF);
                            } else {
                                Helper.renderItemInGui(stack, x + 2, y - 18, 1.0f);
                            }
                            Helper.renderItemInGui(ITEM_FRAME, x - 24, y - 24, 1.0f);
                            mc.func_110434_K().func_110577_a(OVERLAYS);
                            int u = chute.isBlacklist ? 240 : 224;
                            GlStateManager.func_227731_j_();
                            AbstractGui.blit((int)(x - 18), (int)(y - 18), (float)u, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                            GlStateManager.func_227734_k_();
                        } else if (tile instanceof TileEntityItemDistributor) {
                            TileEntityItemDistributor distributor = (TileEntityItemDistributor)tile;
                            Helper.renderItemInGui(DISPENSER, x - 24, y - 24, 1.0f);
                            mc.func_110434_K().func_110577_a(OVERLAYS);
                            int u = !distributor.isRandomMode ? 240 : 224;
                            GlStateManager.func_227731_j_();
                            AbstractGui.blit((int)(x - 18), (int)(y - 18), (float)u, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                            GlStateManager.func_227734_k_();
                        }
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.popMatrix();
                }
            }
        }
    }

    private void drawContainerInfo(int stored, int max, int color, Minecraft mc, MainWindow res, int yOffset, String name, String textBelow) {
        RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        int x = res.func_198107_o() / 2 - 40;
        int y = res.func_198087_p() / 2 + yOffset;
        int width = MathHelper.func_76123_f((float)((float)stored / (float)max * 80.0f));
        mc.func_110434_K().func_110577_a(OVERLAYS);
        if (width < 80) {
            AbstractGui.blit((int)(x + width), (int)y, (float)width, (float)0.0f, (int)(80 - width), (int)6, (int)256, (int)256);
        }
        if (width > 0) {
            AbstractGui.blit((int)x, (int)y, (float)0.0f, (float)6.0f, (int)width, (int)6, (int)256, (int)256);
        }
        mc.field_71466_p.func_175063_a(name, (float)(x + 40) - (float)mc.field_71466_p.func_78256_a(name) / 2.0f, (float)(y - 9), color);
        if (textBelow != null) {
            mc.field_71466_p.func_175063_a(textBelow, (float)(x + 40) - (float)mc.field_71466_p.func_78256_a(textBelow) / 2.0f, (float)(y + 7), color);
        }
    }
}

